
<?php $__env->startPush('title'); ?>
    <?php echo e(__(@$pageTitle)); ?>

<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="px-24 pb-24 position-relative">
        <!--  -->
        <div class="p-20 bd-one bd-c-stroke-color bd-ra-12 bg-white overflow-hidden">
            <div class="zTab-vertical-wrap">
                <!-- Left -->
                <div class="left">
                    <?php echo $__env->make('user.settings.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <!-- Right -->
                <div class="right">
                    <div class="tab-content" id="myTabContent">
                        <!-- Account Settings -->
                        <div class="tab-pane fade show active" id="accountSettings-tab-pane" role="tabpanel"
                            aria-labelledby="accountSettings-tab" tabindex="0">
                            <form action="<?php echo e(route('user.settings.profile.update')); ?>" method="POST" class="ajax reset"
                                data-handler="commonResponseWithPageLoad">
                                <?php echo csrf_field(); ?>
                                <h4 class="fs-18 fw-700 lh-24 text-textBlack pb-19 mb-19 bd-b-one bd-c-stroke-color">
                                    <?php echo e(__('Personal Information')); ?></h4>
                                <!-- Photo -->
                                <div class="pb-30">
                                    <div class="upload-img-box profileImage-upload">
                                        <div class="icon">
                                            <img src="<?php echo e(asset('user/images/icon/camera.svg')); ?>" />
                                        </div>
                                        <img src="<?php echo e(getFileUrl($user->image)); ?>" />
                                        <input type="file" name="image" id="zImageUpload" accept="image/*"
                                            onchange="previewFile(this)" />
                                    </div>
                                </div>
                                <!-- Inputs -->
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="name" class="zForm-label"><?php echo e(__('Name')); ?></label>
                                            <input type="text" name="name" class="form-control zForm-control"
                                                id="name" value="<?php echo e($user->name); ?>"
                                                placeholder="<?php echo e(__('Name')); ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="email" class="zForm-label"><?php echo e(__('Email')); ?></label>
                                            <input type="email" name="email" class="form-control zForm-control"
                                                id="email" value="<?php echo e($user->email); ?>"
                                                placeholder="<?php echo e(__('Email')); ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="mobile" class="zForm-label"><?php echo e(__('Phone')); ?></label>
                                            <input type="text" name="mobile" class="form-control zForm-control"
                                                id="mobile" value="<?php echo e($user->mobile); ?>"
                                                placeholder="<?php echo e(__('Phone')); ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label class="zForm-label"><?php echo e(__('Currency')); ?></label>
                                            <select class="sf-select-two cs-select-form" name="currency">
                                                <?php $__currentLoopData = getCurrency(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($key); ?>"
                                                        <?php echo e($user->currency == $key ? 'selected' : ''); ?>>
                                                        <?php echo e($currency); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="country" class="zForm-label"><?php echo e(__('Country')); ?></label>
                                            <input type="text" name="country" class="form-control zForm-control"
                                                id="country" value="<?php echo e($user->country); ?>"
                                                placeholder="<?php echo e(__('Country')); ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="city" class="zForm-label"><?php echo e(__('City')); ?></label>
                                            <input type="text" name="city" class="form-control zForm-control"
                                                id="city" value="<?php echo e($user->city); ?>"
                                                placeholder="<?php echo e(__('City')); ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="zip_code" class="zForm-label"><?php echo e(__('Zip Code')); ?></label>
                                            <input type="text" name="zip_code" class="form-control zForm-control"
                                                id="zip_code" value="<?php echo e($user->zip_code); ?>"
                                                placeholder="<?php echo e(__('Zip Code')); ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="address" class="zForm-label"><?php echo e(__('Address')); ?></label>
                                            <input type="text" name="address" class="form-control zForm-control"
                                                id="address" value="<?php echo e($user->address); ?>"
                                                placeholder="<?php echo e(__('Address')); ?>" />
                                        </div>
                                    </div>
                                </div>
                                <!--  -->
                                <h4 class="fs-18 fw-700 lh-24 text-textBlack pb-19 mb-19 bd-b-one bd-c-stroke-color">
                                    <?php echo e(__('Organization Details')); ?></h4>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="cName" class="zForm-label"><?php echo e(__('Company Name')); ?></label>
                                            <input type="text" name="company_name" class="form-control zForm-control"
                                                id="cName" value="<?php echo e($user->company_name); ?>"
                                                placeholder="<?php echo e(__('Company Name')); ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="cDesignation" class="zForm-label"><?php echo e(__('Designation')); ?></label>
                                            <input type="text" name="company_designation"
                                                class="form-control zForm-control" id="cDesignation"
                                                value="<?php echo e($user->company_designation); ?>"
                                                placeholder="<?php echo e(__('Designation')); ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="cCountry" class="zForm-label"><?php echo e(__('Country')); ?></label>
                                            <input type="text" name="company_country"
                                                class="form-control zForm-control" id="cCountry"
                                                value="<?php echo e($user->company_country); ?>"
                                                placeholder="<?php echo e(__('Country')); ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="cCity" class="zForm-label"><?php echo e(__('City')); ?></label>
                                            <input type="text" name="company_city" class="form-control zForm-control"
                                                id="cCity" value="<?php echo e($user->company_city); ?>"
                                                placeholder="<?php echo e(__('City')); ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="cZipCode" class="zForm-label"><?php echo e(__('Zip Code')); ?></label>
                                            <input type="text" name="company_zip_code"
                                                class="form-control zForm-control" id="cZipCode"
                                                value="<?php echo e($user->company_zip_code); ?>"
                                                placeholder="<?php echo e(__('Zip Code')); ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="cAddress" class="zForm-label"><?php echo e(__('Address')); ?></label>
                                            <input type="text" name="company_address"
                                                class="form-control zForm-control" id="cAddress"
                                                value="<?php echo e($user->company_address); ?>"
                                                placeholder="<?php echo e(__('Address')); ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="uploadDepositSlip"
                                                class="zForm-label"><?php echo e(__('Company Logo')); ?></label>
                                            <input type="file" name="company_logo" class="form-control zForm-control"
                                                id="uploadDepositSlip">
                                        </div>
                                    </div>
                                </div>
                                <h4 class="fs-18 fw-700 lh-24 text-textBlack pb-19 mb-19 bd-b-one bd-c-stroke-color">
                                    <?php echo e(__('Change Password')); ?></h4>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="cName" class="zForm-label"><?php echo e(__('Password')); ?></label>
                                            <input type="password" name="pass1" class="form-control zForm-control"
                                                id="cName" value=""
                                                placeholder="<?php echo e(__('Re Enter Password')); ?>" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="zForm-wrap pb-20">
                                            <label for="cDesignation" class="zForm-label"><?php echo e(__('Re Password')); ?></label>
                                            <input type="password" name="pass2" class="form-control zForm-control"
                                                id="cDesignation" value=""
                                                placeholder="<?php echo e(__('Re Enter Password')); ?>" />
                                        </div>
                                    </div>
                                </div>
                                <!-- Buttons -->
                                <div class="d-flex align-items-center cg-10">
                                    <button
                                        class="border-0 bd-ra-12 py-13 px-25 bg-main-color fs-16 fw-600 lh-19 text-white"><?php echo e(__('Update')); ?></button>
                                </div>
                            </form>
                        </div>
                        <!-- Checkout page settings -->
                        <div class="tab-pane fade" id="checkoutPageSettings-tab-pane" role="tabpanel"
                            aria-labelledby="checkoutPageSettings-tab" tabindex="0">
                            <!--  -->
                            <div
                                class="d-flex justify-content-between align-items-center flex-wrap g-10 bd-b-one bd-c-stroke-2-color pb-20 mb-15">
                                <div>
                                    <h4 class="fs-18 fw-700 lh-24 text-textBlack pb-5"><?php echo e(__('Checkout Page Settings')); ?>

                                    </h4>
                                </div>
                            </div>
                            <!-- Multi form -->
                            <div id="msform">
                                <ul id="progressbar">
                                    <li class="active"><?php echo e(__('Header Settings')); ?></li>
                                    <li><?php echo e(__('Basic Info')); ?></li>
                                    <li><?php echo e(__('Billing Info')); ?></li>
                                    <li><?php echo e(__('Shipping Info')); ?></li>
                                    <li><?php echo e(__('Payment Info')); ?></li>
                                    <li><?php echo e(__('Confirmation')); ?></li>
                                </ul>
                                <!-- Header settings -->
                                <fieldset>
                                    <form class="ajax" action="<?php echo e(route('user.settings.checkout.page.update')); ?>"
                                        method="POST" data-handler="getCheckoutPageUpdateRes">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="step" class="d-none" value="1">
                                        <div>
                                            <h4 class="fs-16 fw-600 lh-24 text-textBlack pb-15">
                                                <?php echo e(__('Header Settings')); ?>

                                            </h4>
                                            <div class="row">
                                                <div class="col-lg-6">
                                                    <div class="zForm-wrap zImage-upload-details mb-20">
                                                        <div class="zImage-inside">
                                                            <div class="d-flex pb-12">
                                                                <img
                                                                    src="<?php echo e(asset('user/images/icon/cloud-upload.svg')); ?>" />
                                                            </div>
                                                            <p class="fs-15 fw-500 lh-16 text-1b1c17">
                                                                <?php echo e(__('Drag & Drop Files Here')); ?></p>
                                                        </div>
                                                        <label for="zImageUpload"
                                                            class="zForm-label"><?php echo e(__('Upload Image')); ?></label>
                                                        <div class="upload-img-box">
                                                            <?php if($checkoutPage): ?>
                                                                <img src="<?php echo e(getFileUrl($checkoutPage?->image)); ?>" />
                                                            <?php endif; ?>
                                                            <input type="file" name="image" id="zImageUpload"
                                                                accept="image/*,video/*" onchange="previewFile(this)" />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row rg-20 pb-25">
                                                <div class="col-lg-6">
                                                    <div class="zForm-wrap">
                                                        <label for="msHeaderTitle"
                                                            class="zForm-label"><?php echo e(__('Header Title')); ?></label>
                                                        <input type="text" class="form-control zForm-control"
                                                            name="title" id="msHeaderTitle"
                                                            value="<?php echo e($checkoutPage?->title); ?>"
                                                            placeholder="<?php echo e(__('Header Title')); ?>" />
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="zForm-wrap">
                                                        <label for="msHeaderTextSize"
                                                            class="zForm-label"><?php echo e(__('Header Text Size')); ?></label>
                                                        <input type="text" class="form-control zForm-control"
                                                            name="text_size" id="msHeaderTextSize"
                                                            value="<?php echo e($checkoutPage?->text_size); ?>"
                                                            placeholder="<?php echo e(__('16px')); ?>" />
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="zForm-wrap">
                                                        <label for="msHeaderTextColor"
                                                            class="zForm-label"><?php echo e(__('Header Text Color')); ?></label>
                                                        <input type="text" class="form-control zForm-control"
                                                            name="text_color" id="msHeaderTextColor"
                                                            value="<?php echo e($checkoutPage?->text_color); ?>"
                                                            placeholder="<?php echo e(__('Hex')); ?>" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <button type="submit"
                                            class="action-button nextStep1"><?php echo e(__('Save & Next')); ?></button>
                                    </form>
                                </fieldset>
                                <!-- Basic Info -->
                                <fieldset>
                                    <form class="ajax" action="<?php echo e(route('user.settings.checkout.page.update')); ?>"
                                        method="POST" data-handler="getCheckoutPageUpdateRes">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="step" class="d-none" value="2">
                                        <div>
                                            <h4 class="fs-16 fw-600 lh-24 text-textBlack pb-15"><?php echo e(__('Basic Info')); ?>

                                            </h4>
                                            <div class="row rg-20 pb-25">
                                                <div class="col-lg-12 basicInfoAppend">
                                                    <div class="row mb-2">
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                <select class="form-control zForm-control" disabled>
                                                                    <option value="text"><?php echo e(__('Text')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                <input type="" class="form-control zForm-control"
                                                                    value="First Name" disabled />
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control zForm-control rounded"
                                                                        value="First Name" disabled />
                                                                    <button type="button"
                                                                        class="bg-white border-0 input-group-text text-default"
                                                                        disabled>
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                <select class="form-control zForm-control" disabled>
                                                                    <option value="text"><?php echo e(__('Text')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                <input type="" class="form-control zForm-control"
                                                                    value="Last Name" disabled />
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control zForm-control rounded"
                                                                        value="Last Name" disabled />
                                                                    <button type="button"
                                                                        class="bg-white border-0 input-group-text text-default"
                                                                        disabled>
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                <select class="form-control zForm-control" disabled>
                                                                    <option value=""><?php echo e(__('Email')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                <input type="text" class="form-control zForm-control"
                                                                    value="Email" disabled />
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control zForm-control rounded"
                                                                        value="Email" disabled />
                                                                    <button type="button"
                                                                        class="bg-white border-0 input-group-text text-default"
                                                                        disabled>
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                <select class="form-control zForm-control" disabled>
                                                                    <option value=""><?php echo e(__('Text')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                <input type="text" class="form-control zForm-control"
                                                                    value="Phone" disabled />
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control zForm-control rounded"
                                                                        value="Phone" disabled />
                                                                    <button type="button"
                                                                        class="bg-white border-0 input-group-text text-default"
                                                                        disabled>
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                <select class="form-control zForm-control" disabled>
                                                                    <option value=""><?php echo e(__('Text')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                <input type="text" class="form-control zForm-control"
                                                                    value="Company" disabled />
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label
                                                                    class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control zForm-control rounded"
                                                                        value="Company" disabled />
                                                                    <button type="button"
                                                                        class="bg-white border-0 input-group-text text-default"
                                                                        disabled>
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php $__currentLoopData = json_decode($checkoutPage?->basic_info) ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $basicInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="row mb-2">
                                                            <div class="col-lg-4">
                                                                <div class="zForm-wrap">
                                                                    <label
                                                                        class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                    <select class="form-control zForm-control basic-type"
                                                                        name="basic[type][]">
                                                                        <option value="text"
                                                                            <?php echo e($basicInfo->type == 'text' ? 'selected' : ''); ?>>
                                                                            <?php echo e(__('Text')); ?>

                                                                        </option>
                                                                        <option value="number"
                                                                            <?php echo e($basicInfo->type == 'number' ? 'selected' : ''); ?>>
                                                                            <?php echo e(__('Number')); ?>

                                                                        </option>
                                                                        <option value="textarea"
                                                                            <?php echo e($basicInfo->type == 'textarea' ? 'selected' : ''); ?>>
                                                                            <?php echo e(__('Textarea')); ?>

                                                                        </option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-4">
                                                                <div class="zForm-wrap">
                                                                    <label
                                                                        class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                    <input type="text"
                                                                        class="form-control zForm-control basic-label"
                                                                        name="basic[label][]"
                                                                        value="<?php echo e($basicInfo->label); ?>"
                                                                        placeholder="<?php echo e(__('Label')); ?>" />
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-4">
                                                                <div class="zForm-wrap">
                                                                    <label
                                                                        class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                    <div class="input-group">
                                                                        <input type="text"
                                                                            class="form-control zForm-control rounded basic-placeholder"
                                                                            name="basic[placeholder][]"
                                                                            value="<?php echo e($basicInfo->placeholder); ?>"
                                                                            placeholder="<?php echo e(__('Placeholder')); ?>" />
                                                                        <button type="button"
                                                                            class="bg-white border-0 input-group-text removeInfoBtn text-danger">
                                                                            <i class="fa-solid fa-trash"></i>
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                                <div class="col-12">
                                                    <button type="button"
                                                        class="border-0 p-0 bg-transparent fs-14 fw-500 lh-17 text-main-color addBasicInfoFieldBtn"><?php echo e(__('+Add Info')); ?></button>
                                                </div>
                                            </div>
                                        </div>
                                        <input type="button" name="previous" class="previousBtn action-button-previous"
                                            value="Previous" />
                                        <button type="submit"
                                            class="action-button nextStep2"><?php echo e(__('Save & Next')); ?></button>
                                    </form>
                                </fieldset>
                                <!-- Billing Info -->
                                <fieldset>
                                    <form class="ajax" action="<?php echo e(route('user.settings.checkout.page.update')); ?>"
                                        method="POST" data-handler="getCheckoutPageUpdateRes">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="step" class="d-none" value="3">
                                        <div>
                                            <h4 class="fs-16 fw-600 lh-24 text-textBlack pb-15"><?php echo e(__('Billing Info')); ?>

                                            </h4>
                                            <div class="row rg-20 pb-25">
                                                <div class="col-lg-12 billingInfoAppend">
                                                    <div class="row mb-2">
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                <select class="form-control zForm-control" disabled>
                                                                    <option value="text"><?php echo e(__('Text')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                <input type="" class="form-control zForm-control"
                                                                    value="Address" disabled />
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label
                                                                    class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control zForm-control rounded"
                                                                        value="Address" disabled />
                                                                    <button type="button"
                                                                        class="bg-white border-0 input-group-text text-default"
                                                                        disabled>
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                <select class="form-control zForm-control" disabled>
                                                                    <option value="text"><?php echo e(__('Text')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                <input type="" class="form-control zForm-control"
                                                                    value="Zip Code" disabled />
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label
                                                                    class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control zForm-control rounded"
                                                                        value="Zip Code" disabled />
                                                                    <button type="button"
                                                                        class="bg-white border-0 input-group-text text-default"
                                                                        disabled>
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                <select class="form-control zForm-control" disabled>
                                                                    <option value="text"><?php echo e(__('Text')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                <input type="" class="form-control zForm-control"
                                                                    value="City" disabled />
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label
                                                                    class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control zForm-control rounded"
                                                                        value="City" disabled />
                                                                    <button type="button"
                                                                        class="bg-white border-0 input-group-text text-default"
                                                                        disabled>
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                <select class="form-control zForm-control" disabled>
                                                                    <option value="text"><?php echo e(__('Text')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                <input type="" class="form-control zForm-control"
                                                                    value="State" disabled />
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label
                                                                    class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control zForm-control rounded"
                                                                        value="State" disabled />
                                                                    <button type="button"
                                                                        class="bg-white border-0 input-group-text text-default"
                                                                        disabled>
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                <select class="form-control zForm-control" disabled>
                                                                    <option value="text"><?php echo e(__('Text')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                <input type="" class="form-control zForm-control"
                                                                    value="Country" disabled />
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label
                                                                    class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control zForm-control rounded"
                                                                        value="Country" disabled />
                                                                    <button type="button"
                                                                        class="bg-white border-0 input-group-text text-default"
                                                                        disabled>
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php $__currentLoopData = json_decode($checkoutPage?->billing_info) ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $billingInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="row mb-2">
                                                            <div class="col-lg-4">
                                                                <div class="zForm-wrap">
                                                                    <label
                                                                        class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                    <select class="form-control zForm-control billing-type"
                                                                        name="billing[type][]">
                                                                        <option value="text"
                                                                            <?php echo e($billingInfo->type == 'text' ? 'selected' : ''); ?>>
                                                                            <?php echo e(__('Text')); ?>

                                                                        </option>
                                                                        <option value="number"
                                                                            <?php echo e($billingInfo->type == 'number' ? 'selected' : ''); ?>>
                                                                            <?php echo e(__('Number')); ?>

                                                                        </option>
                                                                        <option value="textarea"
                                                                            <?php echo e($billingInfo->type == 'textarea' ? 'selected' : ''); ?>>
                                                                            <?php echo e(__('Textarea')); ?>

                                                                        </option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-4">
                                                                <div class="zForm-wrap">
                                                                    <label
                                                                        class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                    <input type="text"
                                                                        class="form-control zForm-control billing-label"
                                                                        name="billing[label][]"
                                                                        value="<?php echo e($billingInfo->label); ?>"
                                                                        placeholder="<?php echo e(__('Label')); ?>" />
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-4">
                                                                <div class="zForm-wrap">
                                                                    <label
                                                                        class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                    <div class="input-group">
                                                                        <input type="text"
                                                                            class="form-control zForm-control rounded billing-placeholder"
                                                                            name="billing[placeholder][]"
                                                                            value="<?php echo e($billingInfo->placeholder); ?>"
                                                                            placeholder="<?php echo e(__('Placeholder')); ?>" />
                                                                        <button type="button"
                                                                            class="bg-white border-0 input-group-text removeInfoBtn text-danger">
                                                                            <i class="fa-solid fa-trash"></i>
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                                <div class="col-12">
                                                    <button type="button"
                                                        class="border-0 p-0 bg-transparent fs-14 fw-500 lh-17 text-main-color addBillingInfoFieldBtn"><?php echo e(__('+Add Info')); ?></button>
                                                </div>
                                            </div>
                                        </div>
                                        <input type="button" name="previous" class="previousBtn action-button-previous"
                                            value="Previous" />
                                        <button type="submit"
                                            class="action-button nextStep3"><?php echo e(__('Save & Next')); ?></button>
                                    </form>
                                </fieldset>
                                <!-- Shipping Info -->
                                <fieldset>
                                    <form class="ajax" action="<?php echo e(route('user.settings.checkout.page.update')); ?>"
                                        method="POST" data-handler="getCheckoutPageUpdateRes">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="step" class="d-none" value="4">
                                        <div>
                                            <h4 class="fs-16 fw-600 lh-24 text-textBlack pb-15"><?php echo e(__('Shipping Info')); ?>

                                            </h4>
                                            <div class="row rg-20 pb-25">
                                                <div class="col-lg-12 shippingInfoAppend">
                                                    <div class="row mb-2">
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                <select class="form-control zForm-control" disabled>
                                                                    <option value="text"><?php echo e(__('Text')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                <input type="" class="form-control zForm-control"
                                                                    value="Address" disabled />
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label
                                                                    class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control zForm-control rounded"
                                                                        value="Address" disabled />
                                                                    <button type="button"
                                                                        class="bg-white border-0 input-group-text text-default"
                                                                        disabled>
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                <select class="form-control zForm-control" disabled>
                                                                    <option value="text"><?php echo e(__('Text')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                <input type="" class="form-control zForm-control"
                                                                    value="Zip Code" disabled />
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label
                                                                    class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control zForm-control rounded"
                                                                        value="Zip Code" disabled />
                                                                    <button type="button"
                                                                        class="bg-white border-0 input-group-text text-default"
                                                                        disabled>
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                <select class="form-control zForm-control" disabled>
                                                                    <option value="text"><?php echo e(__('Text')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                <input type="" class="form-control zForm-control"
                                                                    value="City" disabled />
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label
                                                                    class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control zForm-control rounded"
                                                                        value="City" disabled />
                                                                    <button type="button"
                                                                        class="bg-white border-0 input-group-text text-default"
                                                                        disabled>
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                <select class="form-control zForm-control" disabled>
                                                                    <option value="text"><?php echo e(__('Text')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                <input type="" class="form-control zForm-control"
                                                                    value="State" disabled />
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label
                                                                    class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control zForm-control rounded"
                                                                        value="State" disabled />
                                                                    <button type="button"
                                                                        class="bg-white border-0 input-group-text text-default"
                                                                        disabled>
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                <select class="form-control zForm-control" disabled>
                                                                    <option value="text"><?php echo e(__('Text')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                <input type="" class="form-control zForm-control"
                                                                    value="Country" disabled />
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="zForm-wrap">
                                                                <label
                                                                    class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text"
                                                                        class="form-control zForm-control rounded"
                                                                        value="Country" disabled />
                                                                    <button type="button"
                                                                        class="bg-white border-0 input-group-text text-default"
                                                                        disabled>
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php $__currentLoopData = json_decode($checkoutPage?->shipping_info) ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shippingInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="row mb-2">
                                                            <div class="col-lg-4">
                                                                <div class="zForm-wrap">
                                                                    <label
                                                                        class="zForm-label"><?php echo e(__('Type')); ?></label>
                                                                    <select
                                                                        class="form-control zForm-control shipping-type"
                                                                        name="shipping[type][]">
                                                                        <option value="text"
                                                                            <?php echo e($shippingInfo->type == 'text' ? 'selected' : ''); ?>>
                                                                            <?php echo e(__('Text')); ?>

                                                                        </option>
                                                                        <option value="number"
                                                                            <?php echo e($shippingInfo->type == 'number' ? 'selected' : ''); ?>>
                                                                            <?php echo e(__('Number')); ?>

                                                                        </option>
                                                                        <option value="textarea"
                                                                            <?php echo e($shippingInfo->type == 'textarea' ? 'selected' : ''); ?>>
                                                                            <?php echo e(__('Textarea')); ?>

                                                                        </option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-4">
                                                                <div class="zForm-wrap">
                                                                    <label
                                                                        class="zForm-label"><?php echo e(__('Label')); ?></label>
                                                                    <input type="text"
                                                                        class="form-control zForm-control shipping-label"
                                                                        name="shipping[label][]"
                                                                        value="<?php echo e($shippingInfo->label); ?>"
                                                                        placeholder="<?php echo e(__('Label')); ?>" />
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-4">
                                                                <div class="zForm-wrap">
                                                                    <label
                                                                        class="zForm-label"><?php echo e(__('Placeholder')); ?></label>
                                                                    <div class="input-group">
                                                                        <input type="text"
                                                                            class="form-control zForm-control rounded shipping-placeholder"
                                                                            name="shipping[placeholder][]"
                                                                            value="<?php echo e($shippingInfo->placeholder); ?>"
                                                                            placeholder="<?php echo e(__('Placeholder')); ?>" />
                                                                        <button type="button"
                                                                            class="bg-white border-0 input-group-text removeInfoBtn text-danger">
                                                                            <i class="fa-solid fa-trash"></i>
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                                <div class="col-12">
                                                    <button type="button"
                                                        class="border-0 p-0 bg-transparent fs-14 fw-500 lh-17 text-main-color addShippingInfoFieldBtn"><?php echo e(__('+Add Info')); ?></button>
                                                </div>
                                            </div>
                                            <h4 class="fs-16 fw-600 lh-24 text-textBlack pb-15">
                                                <?php echo e(__('Shipping Method')); ?>

                                            </h4>
                                            <div class="row rg-20 pb-25">
                                                <div class="col-lg-6">
                                                    <div class="bd-one bd-c-stroke-color bd-ra-8 bg-input-color p-16">
                                                        <div class="zForm-wrap-checkbox">
                                                            <input class="form-check-input" type="radio" value="1"
                                                                id="msShippingMethodFree" name="shipping_method"
                                                                <?php echo e($checkoutPage?->shipping_method == SHIPPING_METHOD_FREE ? 'checked' : ''); ?> />
                                                            <label class="form-check-label"
                                                                for="msShippingMethodFree"><?php echo e(__('Free')); ?></label>
                                                        </div>
                                                        <p class="pt-12 fs-14 fw-400 lh-17 text-para-text">
                                                            <?php echo e(__('We deliver free to save you money')); ?></p>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="bd-one bd-c-stroke-color bd-ra-8 bg-input-color p-16">
                                                        <div class="zForm-wrap-checkbox">
                                                            <input class="form-check-input" type="radio" value="2"
                                                                id="msShippingMethodFastDelivery" name="shipping_method"
                                                                <?php echo e($checkoutPage?->shipping_method == SHIPPING_METHOD_PAID ? 'checked' : ''); ?> />
                                                            <label class="form-check-label"
                                                                for="msShippingMethodFastDelivery"><?php echo e(__('Paid')); ?></label>
                                                        </div>
                                                        <p class="pt-12 fs-14 fw-400 lh-17 text-para-text">
                                                            <?php echo e(__('We take your deliveries seriously.')); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <input type="button" name="previous" class="previousBtn action-button-previous"
                                            value="Previous" />
                                        <button type="submit"
                                            class="action-button nextStep4"><?php echo e(__('Save & Next')); ?></button>
                                    </form>
                                </fieldset>
                                <!-- Payment Selection -->
                                <fieldset>
                                    <form class="ajax" action="<?php echo e(route('user.settings.checkout.page.update')); ?>"
                                        method="POST" data-handler="getCheckoutPageUpdateRes">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="step" class="d-none" value="5">
                                        <div>
                                            <h4 class="fs-16 fw-600 lh-24 text-textBlack pb-20">
                                                <?php echo e(__('Payment Selection')); ?>

                                            </h4>
                                            <div class="pb-40 d-flex align-items-center flex-wrap rg-25 cg-10">
                                                <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($gateway->title == "Paystack"): ?>
                                                    <div class="position-relative flex-grow-1 max-w-419 w-100">
                                                        <div
                                                            class="zForm-wrap-radio py-13 px-15 bd-one bd-c-stroke-2-color bd-ra-8 bg-input-color">
                                                            <input class="form-check-input" type="checkbox"
                                                                value="<?php echo e($gateway->id); ?>"
                                                                id="checkoutPaymentItemStripe<?php echo e($key); ?>"
                                                                <?php echo e(in_array($gateway->id, json_decode($checkoutPage?->payment) ?? []) ? 'checked' : ''); ?>

                                                                name="gateways[]" />
                                                            <label class="form-check-label"
                                                                for="checkoutPaymentItemStripe<?php echo e($key); ?>"><?php echo e($gateway->title); ?></label>
                                                        </div>
                                                        <div
                                                            class="position-absolute top-50 end-0 translate-middle-y pr-15">
                                                            <img src="<?php echo e(asset($gateway->image)); ?>" alt="" />
                                                        </div>
                                                    </div>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                        <input type="button" name="previous" class="previousBtn action-button-previous"
                                            value="Previous" />
                                        <button type="submit"
                                            class="action-button nextStep5"><?php echo e(__('Save & Next')); ?></button>
                                    </form>
                                </fieldset>
                                <!-- Confirmation Selection -->
                                <fieldset>
                                    <form class="ajax" action="<?php echo e(route('user.settings.checkout.page.update')); ?>"
                                        method="POST" data-handler="getCheckoutPageUpdateRes">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="step" class="d-none" value="6">
                                        <div>
                                            <h4 class="fs-16 fw-600 lh-24 text-textBlack pb-20"><?php echo e(__('Details')); ?></h4>
                                            <div class="d-flex flex-column rg-20 pb-25">
                                                <!-- Basic Info -->
                                                <div class="py-23 px-28 bd-ra-8 bg-secondary-color">
                                                    <h4 class="fs-16 fw-600 lh-24 text-textBlack pb-11">
                                                        <?php echo e(__('Basic Info')); ?></h4>
                                                    <p class="fs-14 fw-500 lh-24 text-para-text">
                                                        <?php echo e(__('First Name')); ?>:<span
                                                            class="fw-400"><?php echo e(__('Text')); ?></span>
                                                    </p>
                                                    <p class="fs-14 fw-500 lh-24 text-para-text">
                                                        <?php echo e(__('Last Name')); ?>:<span
                                                            class="fw-400"><?php echo e(__('Text')); ?></span>
                                                    </p>
                                                    <p class="fs-14 fw-500 lh-24 text-para-text">
                                                        <?php echo e(__('Email')); ?>:<span
                                                            class="fw-400"><?php echo e(__('Email')); ?></span>
                                                    </p>
                                                    <p class="fs-14 fw-500 lh-24 text-para-text">
                                                        <?php echo e(__('Phone')); ?>:<span
                                                            class="fw-400"><?php echo e(__('Text')); ?></span>
                                                    </p>
                                                    <p class="fs-14 fw-500 lh-24 text-para-text">
                                                        <?php echo e(__('Company')); ?>:<span
                                                            class="fw-400"><?php echo e(__('Text')); ?></span>
                                                    </p>
                                                    <?php $__currentLoopData = json_decode($checkoutPage?->basic_info) ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $basicInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <p class="fs-14 fw-500 lh-24 text-para-text">
                                                            <?php echo e($basicInfo->label); ?>

                                                            :
                                                            <span class="fw-400"><?php echo e($basicInfo->type); ?></span>
                                                        </p>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                                <!-- Billing Info -->
                                                <div class="py-23 px-28 bd-ra-8 bg-secondary-color">
                                                    <h4 class="fs-16 fw-600 lh-24 text-textBlack pb-11">
                                                        <?php echo e(__('Billing Info')); ?></h4>
                                                    <p class="fs-14 fw-500 lh-24 text-para-text">
                                                        <?php echo e(__('Address')); ?>:<span
                                                            class="fw-400"><?php echo e(__('Text')); ?></span>
                                                    </p>
                                                    <p class="fs-14 fw-500 lh-24 text-para-text">
                                                        <?php echo e(__('Zip Code')); ?>:<span
                                                            class="fw-400"><?php echo e(__('Text')); ?></span>
                                                    </p>
                                                    <p class="fs-14 fw-500 lh-24 text-para-text">
                                                        <?php echo e(__('City')); ?>:<span
                                                            class="fw-400"><?php echo e(__('Text')); ?></span>
                                                    </p>
                                                    <p class="fs-14 fw-500 lh-24 text-para-text">
                                                        <?php echo e(__('State')); ?>:<span
                                                            class="fw-400"><?php echo e(__('Text')); ?></span>
                                                    </p>
                                                    <p class="fs-14 fw-500 lh-24 text-para-text">
                                                        <?php echo e(__('Country')); ?>:<span
                                                            class="fw-400"><?php echo e(__('Text')); ?></span>
                                                    </p>
                                                    <?php $__currentLoopData = json_decode($checkoutPage?->billing_info) ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $billingInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <p class="fs-14 fw-500 lh-24 text-para-text">
                                                            <?php echo e($billingInfo->label); ?>

                                                            :
                                                            <span class="fw-400"><?php echo e($billingInfo->type); ?></span>
                                                        </p>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                                <!-- Shipping Info -->
                                                <div class="py-23 px-28 bd-ra-8 bg-secondary-color">
                                                    <h4 class="fs-16 fw-600 lh-24 text-textBlack pb-15">
                                                        <?php echo e(__('Shipping Address')); ?></h4>
                                                    <p class="fs-14 fw-500 lh-24 text-para-text">
                                                        <?php echo e(__('First Name')); ?>:<span
                                                            class="fw-400"><?php echo e(__('Text')); ?></span>
                                                    </p>
                                                    <p class="fs-14 fw-500 lh-24 text-para-text">
                                                        <?php echo e(__('Last Name')); ?>:<span
                                                            class="fw-400"><?php echo e(__('Text')); ?></span>
                                                    </p>
                                                    <p class="fs-14 fw-500 lh-24 text-para-text">
                                                        <?php echo e(__('Email')); ?>:<span
                                                            class="fw-400"><?php echo e(__('Text')); ?></span>
                                                    </p>
                                                    <p class="fs-14 fw-500 lh-24 text-para-text">
                                                        <?php echo e(__('Phone')); ?>:<span
                                                            class="fw-400"><?php echo e(__('Text')); ?></span>
                                                    </p>
                                                    <p class="fs-14 fw-500 lh-24 text-para-text">
                                                        <?php echo e(__('Address')); ?>:<span
                                                            class="fw-400"><?php echo e(__('Text')); ?></span>
                                                    </p>
                                                    <div class="pb-20">
                                                        <?php $__currentLoopData = json_decode($checkoutPage?->shipping_info) ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shippingInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <p class="fs-14 fw-500 lh-24 text-para-text">
                                                                <?php echo e($shippingInfo->label); ?>

                                                                : <span class="fw-400"><?php echo e($shippingInfo->type); ?></span>
                                                            </p>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                    <div>
                                                        <h4 class="fs-12 fw-600 lh-24 text-textBlack">
                                                            <?php echo e(__('Shipping Method')); ?></h4>
                                                        <p class="fs-14 fw-500 lh-24 text-para-text">
                                                            <?php echo e($checkoutPage?->shipping_method == SHIPPING_METHOD_FREE ? __('Free') : __('Paid')); ?>

                                                        </p>
                                                    </div>
                                                </div>
                                                <!-- Payment -->
                                                <div>
                                                    <h4 class="fs-16 fw-600 lh-19 text-textBlack pb-20">
                                                        <?php echo e(__('Payment Gateway')); ?></h4>
                                                    <div id="gatewaysShow">
                                                    </div>
                                                </div>
                                                <div>
                                                    <h4 class="fs-16 fw-600 lh-19 text-textBlack pb-20">
                                                        <?php echo e(__('Status')); ?></h4>
                                                    <div class="col-lg-4">
                                                        <div class="zForm-wrap">
                                                            <select class="form-control zForm-control info-type"
                                                                name="status">
                                                                <option value="1"
                                                                    <?php echo e($checkoutPage?->status == CHECKOUT_PAGE_SETTING_STATUS_ACTIVE ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Active')); ?></option>
                                                                <option value="2"
                                                                    <?php echo e($checkoutPage?->status != CHECKOUT_PAGE_SETTING_STATUS_ACTIVE ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Inactive')); ?></option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <input type="button" name="previous" class="previousBtn action-button-previous"
                                            value="Previous" />
                                        <button type="submit"
                                            class="action-button nextStep6"><?php echo e(__('Confirm')); ?></button>
                                    </form>
                                </fieldset>
                            </div>
                        </div>
                        <!-- Email Notification -->
                        <div class="tab-pane fade" id="emailNotification-tab-pane" role="tabpanel"
                            aria-labelledby="emailNotification-tab" tabindex="0">
                            <!--  -->
                            <h4 class="fs-18 fw-700 lh-24 text-textBlack pb-30"><?php echo e(__('Email Template Settings')); ?>

                                <button
                                    class="border-0 bd-ra-12 bg-main-color py-13 px-25 fs-16 fw-600 lh-19 text-white testEmail"
                                    data-bs-toggle="modal" data-bs-target="#emailTestModal"
                                    fdprocessedid="sjjvzc"><?php echo e(__('Test')); ?></button>
                            </h4>
                            <!-- List -->
                            <ul class="zList-pb-20">
                                <?php $__currentLoopData = emailTemplates(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <input type="hidden" name="category" value="<?php echo e($key); ?>">
                                        <div class="d-flex justify-content-between align-items-center flex-wrap g-10">
                                            <div>
                                                <h5 class="fs-14 fw-500 lh-17 text-textBlack pb-7">
                                                    <?php echo e(__($template['title'])); ?>

                                                </h5>
                                                <p class="fs-12 fw-400 lh-16 text-para-text">
                                                    <?php echo e(__($template['details'])); ?>

                                                </p>
                                            </div>
                                            <div class="d-flex align-items-center flex-wrap cg-47 rg-10">
                                                <div class="zCheck form-check form-switch">
                                                    <input class="form-check-input templateStatus" type="checkbox"
                                                        <?php echo e(emailTemplateStatus($key) == ACTIVE ? 'checked' : ''); ?>

                                                        role="switch" />
                                                </div>
                                                <button type="button"
                                                    class="fs-14 fw-500 lh-17 text-main-color text-decoration-underline btn templateConfigure"><?php echo e(__('Configure')); ?></button>
                                            </div>
                                        </div>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <!-- Webhooks -->
                        <div class="tab-pane fade" id="webhooks-tab-pane" role="tabpanel" aria-labelledby="webhooks-tab"
                            tabindex="0">

                            <div
                                class="d-flex pb-4 justify-content-between align-items-center flex-wrap rg-10 mb-22 border-b bd-c-stroke-2-color">
                                <h4 class="fs-18 fw-700 lh-24 text-textBlack bd-b-one border-0"><?php echo e(__('Webhook')); ?>

                                </h4>
                                <div class="">
                                    <button
                                        class="border-0 bd-ra-12 bg-main-color py-13 px-25 fs-16 fw-600 lh-19 text-white webhookModalBtn"
                                        data-bs-toggle="modal"
                                        data-bs-target="#webhookModal"><?php echo e(__('Add Webhook')); ?></button>
                                </div>
                            </div>

                            <hr>

                            <!-- Table -->
                            <table class="table zTable zTable-last-item-right" id="webhookTable">
                                <thead>
                                    <tr>
                                        <th scope="col">
                                            <div class="min-w-150"><?php echo e(__('Webhook Name')); ?></div>
                                        </th>
                                        <th scope="col">
                                            <div class="min-w-150"><?php echo e(__('Webhook URL')); ?></div>
                                        </th>
                                        <th scope="col">
                                            <div class="min-w-100"><?php echo e(__('Product')); ?></div>
                                        </th>
                                        <th scope="col">
                                            <div class="min-w-100"><?php echo e(__('Plan')); ?></div>
                                        </th>
                                        <th scope="col">
                                            <div><?php echo e(__('status')); ?></div>
                                        </th>
                                        <th scope="col">
                                            <div><?php echo e(__('Action')); ?></div>
                                        </th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                        <!-- Invoice settings -->
                        <div class="tab-pane fade" id="invoiceSettings-tab-pane" role="tabpanel"
                            aria-labelledby="invoiceSettings-tab" tabindex="0">
                            <form class="ajax" action="<?php echo e(route('user.settings.invoice.update')); ?>" method="POST"
                                data-handler="getShowMessage">
                                <?php echo csrf_field(); ?>
                                <div class="pb-30">
                                    <div class="row rg-20">
                                        <div class="col-xl-6 col-md-12">
                                            <div class="zForm-wrap zImage-upload-details mb-20">
                                                <div class="zImage-inside">
                                                    <div class="d-flex pb-12">
                                                        <img src="<?php echo e(asset('user/images/icon/cloud-upload.svg')); ?>" />
                                                    </div>
                                                    <p class="fs-15 fw-500 lh-16 text-1b1c17">
                                                        <?php echo e(__('Drag & Drop Files Here')); ?></p>
                                                </div>
                                                <label for="zImageUploadLogo"
                                                    class="fs-18 fw-600 lh-24 text-textBlack pb-15"><?php echo e(__('Logo')); ?></label>
                                                <div class="upload-img-box">
                                                    <?php if($invoiceSetting): ?>
                                                        <img src="<?php echo e(getFileUrl($invoiceSetting?->logo)); ?>" />
                                                    <?php endif; ?>
                                                    <input type="file" name="logo" id="zImageUploadLogo"
                                                        accept="image/*" onchange="previewFile(this)" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="pb-30">
                                    <div class="row rg-20">
                                        <div class="col-md-6 col-sm-6">
                                            <div class="zForm-wrap">
                                                <h4 class="fs-18 fw-600 lh-24 text-textBlack pb-15"><?php echo e(__('Title')); ?>

                                                </h4>
                                                <input type="text" class="form-control zForm-control" name="title"
                                                    value="<?php echo e($invoiceSetting?->title); ?>"
                                                    placeholder="<?php echo e(__('Title')); ?>" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="p-15 bg-purple-light bd-ra-10 d-flex flex-wrap cg-4 rg-5 mb-25">
                                                <?php $__currentLoopData = invoiceSettingFields(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <span
                                                        class="px-9 bg-white rounded-pill fs-12 fw-400 lh-24 text-textBlack"><?php echo e($field); ?></span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="pb-30">
                                    <div class="row rg-20">
                                        <div class="col-lg-6 col-sm-6">
                                            <div class="zForm-wrap">
                                                <h4 class="fs-18 fw-600 lh-24 text-textBlack pb-15">
                                                    <?php echo e(__('Company Information')); ?></h4>
                                                <textarea name="company_info" class="form-control zForm-control summernoteOne"><?php echo e($invoiceSetting?->company_info); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="pb-30">
                                    <div class="row rg-20">
                                        <div class="col-md-6 col-sm-6">
                                            <div class="zForm-wrap">
                                                <h4 class="fs-18 fw-600 lh-24 text-textBlack pb-15"><?php echo e(__('Prefix')); ?>

                                                </h4>
                                                <input type="text" class="form-control zForm-control" name="prefix"
                                                    value="<?php echo e($invoiceSetting?->prefix); ?>"
                                                    placeholder="<?php echo e(__('Prefix')); ?>" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="pb-30">
                                    <div class="row rg-20">
                                        <div class="col-lg-6 col-sm-6">
                                            <div class="zForm-wrap">
                                                <h4 class="fs-18 fw-600 lh-24 text-textBlack pb-15">
                                                    <?php echo e(__('Information One')); ?></h4>
                                                <textarea name="info_one" class="form-control zForm-control summernoteOne"><?php echo e($invoiceSetting?->info_one); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="pb-30">
                                    <div class="row rg-20">
                                        <div class="col-lg-6 col-sm-6">
                                            <div class="zForm-wrap">
                                                <h4 class="fs-18 fw-600 lh-24 text-textBlack pb-15">
                                                    <?php echo e(__('Information Two')); ?></h4>
                                                <textarea name="info_two" class="form-control zForm-control summernoteOne"><?php echo e($invoiceSetting?->info_two); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="pb-30">
                                    <div class="row rg-20">
                                        <div class="col-lg-6 col-sm-6">
                                            <div class="zForm-wrap">
                                                <h4 class="fs-18 fw-600 lh-24 text-textBlack pb-15">
                                                    <?php echo e(__('Information Three')); ?></h4>
                                                <textarea name="info_three" class="form-control zForm-control summernoteOne"><?php echo e($invoiceSetting?->info_three); ?></textarea>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="pb-30">
                                    <div class="row rg-20">
                                        <div class="col-lg-6 col-sm-6">
                                            <div class="zForm-wrap">
                                                <h4 class="fs-18 fw-600 lh-24 text-textBlack pb-15">
                                                    <?php echo e(__('Footer Text')); ?></h4>
                                                <textarea name="footer_text" class="form-control zForm-control summernoteOne"><?php echo e($invoiceSetting?->footer_text); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="pb-30">
                                    <div class="row rg-20">
                                        <div class="col-lg-6 col-sm-6">
                                            <div class="zForm-wrap pb-20">
                                                <h4 class="fs-18 fw-600 lh-24 text-textBlack pb-15">
                                                    <?php echo e(__('Show Column')); ?></h4>
                                                <div class="d-flex align-items-center flex-wrap g-10">
                                                    <?php $__currentLoopData = getTableColumn(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div
                                                            class="zForm-wrap-checkbox py-11 px-16 bd-one bd-c-stroke-color bd-ra-8 bg-input-color">
                                                            <input class="form-check-input"
                                                                value="<?php echo e($key); ?>" type="checkbox"
                                                                id="tableColumn<?php echo e($key); ?>"
                                                                <?php echo e(in_array($key, json_decode($invoiceSetting?->column) ?? []) ? 'checked' : ''); ?>

                                                                name="column[]">
                                                            <label class="form-check-label"
                                                                for="tableColumn<?php echo e($key); ?>"><?php echo e($column); ?></label>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Buttons -->
                                <div class="d-flex align-items-center cg-10">
                                    <button
                                        class="border-0 bd-ra-12 py-13 px-25 bg-main-color fs-16 fw-600 lh-19 text-white"><?php echo e(__('Update')); ?></button>
                                </div>
                            </form>
                        </div>

                        <!-- Tax Tab start-->
                        <div class="tab-pane fade" id="tax-tab-pane" role="tabpanel" aria-labelledby="tax-tab"
                            tabindex="0">
                            <div
                                class="d-flex pb-4 justify-content-between align-items-center mb-22 border-b bd-c-stroke-2-color">
                                <h4 class="fs-18 fw-700 lh-24 text-textBlack bd-b-one border-0"><?php echo e(__('Tax Settings')); ?>

                                </h4>
                                <div class="">
                                    <button
                                        class="border-0 bd-ra-12 bg-main-color py-13 px-25 fs-16 fw-600 lh-19 text-white testEmail taxModalBtn"
                                        data-bs-toggle="modal"
                                        data-bs-target="#taxModal"><?php echo e(__('Add Rule')); ?></button>
                                </div>
                            </div>

                            <hr>

                            <input type="hidden" id="settingsTaxRoute" value="<?php echo e(route('user.settings')); ?>">
                            <!-- Table -->
                            <table class="table zTable pt-2 zTable-last-item-right" id="taxDataTable">
                                <thead>
                                    <tr>
                                        <th scope="col">
                                            <div class="min-w-120"><?php echo e(__('Rule Name')); ?></div>
                                        </th>
                                        <th scope="col">
                                            <div class="min-sm-w-150"><?php echo e(__('Product')); ?></div>
                                        </th>
                                        <th scope="col">
                                            <div class="min-sm-w-100"><?php echo e(__('Plans')); ?></div>
                                        </th>
                                        <th scope="col">
                                            <div class="min-w-120"><?php echo e(__('Tax Amount')); ?></div>
                                        </th>
                                        <th scope="col">
                                            <div class="min-sm-w-100"><?php echo e(__('Status')); ?></div>
                                        </th>
                                        <th scope="col">
                                            <div><?php echo e(__('Action')); ?></div>
                                        </th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                        <!-- Tax Tab end-->

                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="taxModal" tabindex="-1" aria-labelledby="taxModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content bd-c-stroke-color bd-ra-12 py-25 px-20">
                <div class="d-flex justify-content-between align-items-center cg-10 pb-16">
                    <h4 class="fs-18 fw-600 lh-24 text-textBlack"><?php echo e(__('Add Tax')); ?></h4>
                    <button type="button"
                        class="w-30 h-30 rounded-circle d-flex justify-content-center align-items-center bd-one bd-c-stroke-color bg-transparent"
                        data-bs-dismiss="modal" aria-label="Close"><img
                            src="<?php echo e(asset('user')); ?>/images/icon/close.svg" alt="" />
                    </button>
                </div>
                <form class="ajax reset-form" action="<?php echo e(route('user.settings.tax.store')); ?>" method="POST"
                    data-handler="commonResponse">
                    <?php echo csrf_field(); ?>
                    <div class="col-12 pb-25">
                        <div class="zForm-wrap">
                            <label for="invoiceTotalProductAmount" class="zForm-label"><?php echo e(__('Rule Title')); ?></label>
                            <input type="text" name="tax_rule_name" class="form-control zForm-control"
                                placeholder="<?php echo e(__('Tax Rule')); ?>" />
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="zForm-wrap pb-20">
                            <label class="zForm-label"><?php echo e(__('Select Product')); ?></label>
                            <select class="sf-select-two cs-select-form" id="product-id" name="product_id">
                                <option><?php echo e(__('Select Product')); ?></option>
                                <?php $__currentLoopData = $allProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($product->id); ?>">
                                        <?php echo e($product->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="zForm-wrap pb-20">
                            <label class="zForm-label"><?php echo e(__('Select Plan')); ?></label>
                            <select class="sf-select-two plan-filter-data" name="plan_id">
                                <option value=""><?php echo e(__('Select Plan')); ?></option>
                            </select>
                        </div>
                    </div>

                    <div class="zForm-wrap pb-20">
                        <label for="eInputCouponDiscountType" class="zForm-label"><?php echo e(__('Tax Type')); ?></label>
                        <div class="d-flex align-items-center flex-wrap g-10">
                            <div class="zForm-wrap-checkbox py-11 px-16 bd-one bd-c-stroke-color bd-ra-8 bg-input-color">
                                <input class="form-check-input" value="<?php echo e(DISCOUNT_TYPE_FLAT); ?>" type="radio"
                                    id="couponDiscountTypeFlat" name="tax_type" />
                                <label class="form-check-label"
                                    for="couponDiscountTypeFlat"><?php echo e(__('Flat')); ?></label>
                            </div>
                            <div class="zForm-wrap-checkbox py-11 px-16 bd-one bd-c-stroke-color bd-ra-8 bg-input-color">
                                <input value="<?php echo e(DISCOUNT_TYPE_PERCENT); ?>" class="form-check-input" type="radio"
                                    id="couponDiscountTypePercent" name="tax_type" />
                                <label class="form-check-label"
                                    for="couponDiscountTypePercent"><?php echo e(__('Percent')); ?></label>
                            </div>
                        </div>
                    </div>

                    <div class="col-12 pb-25">
                        <div class="zForm-wrap">
                            <label for="invoiceTotalProductAmount" class="zForm-label"><?php echo e(__('Tax Amount')); ?></label>
                            <input type="text" name="tax_amount" class="form-control zForm-control"
                                placeholder="0.00 (%)" />
                        </div>
                    </div>
                    <button type="submit"
                        class="border-0 bd-ra-12 py-13 px-25 bg-main-color fs-16 fw-600 lh-19 text-white"><?php echo e(__('Save Now')); ?></button>
                </form>
            </div>
        </div>
    </div>
    

    
    <div class="modal fade" id="edit-modal" tabindex="-1" aria-labelledby="taxModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content bd-c-stroke-color bd-ra-12 py-25 px-20">

            </div>
        </div>
    </div>
    

    
    <div class="modal fade" id="emailConfigureModal" tabindex="-1" aria-labelledby="emailConfigureModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content bd-c-stroke-color bd-ra-12 py-25 px-20">
                <div>
                    <h4 class="fs-18 fw-700 lh-24 text-textBlack pb-27"><?php echo e(__('Edit Email Template')); ?></h4>
                    <form class="ajax" action="<?php echo e(route('user.settings.email.template.config.update')); ?>"
                        method="POST" data-handler="commonResponse">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="category">
                        <div class="p-15 bg-purple-light bd-ra-10 d-flex flex-wrap cg-4 rg-5 mb-25 templateFields"></div>
                        <div class="zForm-wrap pb-20">
                            <label for="subject" class="zForm-label"><?php echo e(__('Subject')); ?></label>
                            <input type="text" class="form-control zForm-control" id="subject" name="subject"
                                placeholder="<?php echo e(__('Subject')); ?>" />
                        </div>
                        <div class="zForm-wrap pb-20">
                            <label for="body" class="zForm-label"><?php echo e(__('Body')); ?></label>
                            <textarea class="form-control summernoteOne" id="body" name="body" placeholder="<?php echo e(__('Body')); ?>"></textarea>
                        </div>
                        <div class="d-flex align-items-center cg-10">
                            <button type="submit"
                                class="border-0 bd-ra-12 py-13 px-25 bg-main-color fs-16 fw-600 lh-19 text-white"><?php echo e(__('Update')); ?></button>
                            <button type="button"
                                class="border-0 bd-ra-12 py-13 px-25 bg-cancel-color fs-16 fw-600 lh-19 text-textBlack"
                                data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="emailTestModal" tabindex="-1" aria-labelledby="emailTestModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content bd-c-stroke-color bd-ra-12 py-25 px-20">
                <div>
                    <!--  -->
                    <h4 class="fs-18 fw-700 lh-24 text-textBlack pb-27"><?php echo e(__('Test Email')); ?></h4>
                    <form class="ajax" action="<?php echo e(route('user.settings.email.test')); ?>" method="POST"
                        data-handler="commonResponse">
                        <?php echo csrf_field(); ?>
                        <div class="zForm-wrap pb-20">
                            <label for="email" class="zForm-label"><?php echo e(__('Email')); ?></label>
                            <input type="email" class="form-control zForm-control" id="email" name="email"
                                placeholder="<?php echo e(__('Email')); ?>" />
                        </div>
                        <div class="zForm-wrap pb-20">
                            <label for="subject" class="zForm-label"><?php echo e(__('Template')); ?></label>
                            <select class="sf-select-two cs-select-form" name="category">
                                <?php $__currentLoopData = emailTemplates(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>"><?php echo e(__($template['title'])); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="d-flex align-items-center cg-10">
                            <button type="submit"
                                class="border-0 bd-ra-12 py-13 px-25 bg-main-color fs-16 fw-600 lh-19 text-white"><?php echo e(__('Send')); ?></button>
                            <button type="button"
                                class="border-0 bd-ra-12 py-13 px-25 bg-cancel-color fs-16 fw-600 lh-19 text-textBlack"
                                data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="addFieldMultiformModal" tabindex="-1" aria-labelledby="addFieldMultiformModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content bd-c-stroke-color bd-ra-12 py-25 px-20">
                <!--  -->
                <div class="d-flex justify-content-between align-items-center cg-10 pb-16">
                    <h4 class="fs-18 fw-600 lh-24 text-textBlack">Basic Information</h4>
                    <button type="button"
                        class="w-30 h-30 rounded-circle d-flex justify-content-center align-items-center bd-one bd-c-stroke-color bg-transparent"
                        data-bs-dismiss="modal" aria-label="Close"><img
                            src="<?php echo e(asset('user/images/icon/close.svg')); ?>" alt="" /></button>
                </div>
                <!--  -->
                <form>
                    <div class="zForm-wrap pb-20">
                        <label for="mfModalFirstName" class="zForm-label">First Name<span
                                class="text-red">*</span></label>
                        <input type="text" class="form-control zForm-control" id="mfModalFirstName"
                            placeholder="Enter First Name" />
                    </div>
                    <div class="zForm-wrap pb-20">
                        <label for="mfModalLastName" class="zForm-label">Last Name<span
                                class="text-red">*</span></label>
                        <input type="text" class="form-control zForm-control" id="mfModalLastName"
                            placeholder="Enter Last Name" />
                    </div>
                    <div class="zForm-wrap pb-20">
                        <label for="mfModalEmail" class="zForm-label">Email<span class="text-red">*</span></label>
                        <input type="email" class="form-control zForm-control" id="mfModalEmail"
                            placeholder="Enter Email" />
                    </div>
                    <div class="zForm-wrap pb-20">
                        <label for="mfModalPhoneNumber" class="zForm-label">Phone Number<span
                                class="text-red">*</span></label>
                        <input type="number" class="form-control zForm-control" id="mfModalPhoneNumber"
                            placeholder="Enter Phone Number" />
                    </div>
                    <div class="zForm-wrap pb-20">
                        <div class="d-flex justify-content-between align-items-center pb-11">
                            <label for="mfModalCompanyName" class="zForm-label mb-0">Company Name<span
                                    class="text-red">*</span></label>
                            <div class="zForm-wrap-checkbox">
                                <label class="form-check-label" for="mfModalNeeded1">Needed</label>
                                <input class="form-check-input" type="checkbox" value="" id="mfModalNeeded1"
                                    checked />
                            </div>
                        </div>
                        <input type="number" class="form-control zForm-control" id="mfModalCompanyName"
                            placeholder="Enter Company Name" />
                    </div>
                    <div class="zForm-wrap pb-20">
                        <div class="d-flex justify-content-between align-items-center pb-11">
                            <label for="mfModalWebsite" class="zForm-label">Website<span
                                    class="text-red">*</span></label>
                            <div class="zForm-wrap-checkbox">
                                <label class="form-check-label" for="mfModalNeeded2">Needed</label>
                                <input class="form-check-input" type="checkbox" value=""
                                    id="mfModalNeeded2" />
                            </div>
                        </div>
                        <input type="number" class="form-control zForm-control" id="mfModalWebsite"
                            placeholder="Enter Website" />
                    </div>
                    <button type="button"
                        class="border-0 bd-ra-12 py-13 px-25 bg-main-color fs-16 fw-600 lh-19 text-white">Save
                        Changes</button>
                </form>
            </div>
        </div>
    </div>


    <div class="modal fade" id="webhookModal" tabindex="-1" aria-labelledby="taxModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content bd-c-stroke-color bd-ra-12 py-25 px-20">
                <div>
                    <h4 class="fs-18 fw-700 lh-24 text-textBlack pb-27"><?php echo e(__('Add Webhook')); ?></h4>
                    <form class="ajax reset-form" action="<?php echo e(route('user.webhook.store')); ?>" method="POST"
                        data-handler="settingCommonHandler">
                        <?php echo csrf_field(); ?>
                        <div class="col-12 pb-25">
                            <div class="zForm-wrap">
                                <label for="invoiceTotalProductAmount"
                                    class="zForm-label"><?php echo e(__('Webhook Name')); ?></label>
                                <input type="text" name="webhook_name" class="form-control zForm-control"
                                    placeholder="<?php echo e(__('Webhook Name')); ?>" />
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="zForm-wrap pb-20">
                                <label class="zForm-label"><?php echo e(__('Select Product')); ?></label>
                                <select class="sf-select-two cs-select-form product-change-action" name="product_id">
                                    <option><?php echo e(__('Select Product')); ?></option>
                                    <?php $__currentLoopData = $allProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($product->id); ?>">
                                            <?php echo e($product->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="zForm-wrap pb-20">
                                <label class="zForm-label"><?php echo e(__('Select Plan')); ?></label>
                                <select class="sf-select-two plan-filter-data-for-webhook" name="plan_id">
                                    <option value=""><?php echo e(__('Select Plan')); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-12 pb-25">
                            <div class="zForm-wrap">
                                <label for="invoiceTotalProductAmount"
                                    class="zForm-label"><?php echo e(__('Webhook URL')); ?></label>
                                <input type="text" name="webhook_url" class="form-control zForm-control"
                                    placeholder="" />
                            </div>
                        </div>
                        <button type="submit"
                            class="border-0 bd-ra-12 py-13 px-25 bg-main-color fs-16 fw-600 lh-19 text-white"><?php echo e(__('Save Now')); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="edit-webhook-modal" tabindex="-1" aria-labelledby="taxModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content bd-c-stroke-color bd-ra-12 py-25 px-20">

            </div>
        </div>
    </div>


    <input type="hidden" id="gateways" value="<?php echo e(json_encode($gateways)); ?>">
    <input type="hidden" id="emailTemplateConfigRoute" value="<?php echo e(route('user.settings.email.template.config')); ?>">
    <input type="hidden" id="emailTemplateStatus" value="<?php echo e(route('user.settings.email.template.status')); ?>">
    <input type="hidden" id="settingsRoute" value="<?php echo e(route('user.settings')); ?>">
    <input type="hidden" id="webhookTableRoute" value="<?php echo e(route('user.webhook.list')); ?>">
    <input type="hidden" id="plan-route" value="<?php echo e(route('user.settings.get.plan.data')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('user/custom/js/webhook.js')); ?>"></script>
    <script src="<?php echo e(asset('user/custom/js/tax.js')); ?>"></script>
    <script src="<?php echo e(asset('user/custom/js/settings.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sub/resources/views/user/settings/settings.blade.php ENDPATH**/ ?>