
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center cg-10 pb-24">
            <h4 class="fs-18 fw-600 lh-24 text-textBlack"><?php echo e(__("Edit Product")); ?></h4>
            <button type="button" class="w-30 h-30 rounded-circle d-flex justify-content-center align-items-center bd-one bd-c-stroke-color bg-transparent" data-bs-dismiss="modal" aria-label="Close"><img src="<?php echo e(asset('user')); ?>/images/icon/close.svg" alt="" /></button>
        </div>
        <!-- Body -->
        <form class="ajax" action="<?php echo e(route('user.product.store')); ?>"
              method="POST" enctype="multipart/form-data" data-handler="settingCommonHandler">
            <?php echo csrf_field(); ?>
            <div class="zForm-wrap pb-20">
                <input type="hidden" value="<?php echo e(isset($product->id)?encrypt($product->id):null); ?>" name="id">
                <label for="eInputProductName" class="zForm-label"><?php echo e(__("Product Name")); ?> <span class="text-red">*</span></label>
                <input type="text" class="form-control zForm-control" id="eInputProductName" placeholder="<?php echo e(__("Enter product name")); ?>" name="name" value="<?php echo e(isset($product->name)?$product->name:''); ?>"/>
            </div>
            <div class="zForm-wrap pb-20">
                <label for="eInputProductDescription" class="zForm-label"><?php echo e(__("Product Description")); ?></label>
                <textarea class="form-control zForm-control h-111" id="eInputProductDescription" placeholder="<?php echo e(__("Write your thoughts here....")); ?>" name="description"><?php echo e(isset($product->description)?$product->description:''); ?></textarea>
            </div>

            <div class="zForm-wrap pb-20">
                <label for="eInputPlanPlanStatus" class="zForm-label"><?php echo e(__("Status")); ?></label>
                <div class="d-flex align-items-center flex-wrap g-10">
                    <div
                        class="zForm-wrap-checkbox py-11 px-16 bd-one bd-c-stroke-color bd-ra-8 bg-input-color">
                        <input class="form-check-input" type="radio" value="1" id="planPlanStatusActive"
                                   name="status" <?php echo e(isset($product->status) && $product->status == 1?'checked':''); ?>/>
                        <label class="form-check-label" for="planPlanStatusActive"><?php echo e(__("Active")); ?></label>
                    </div>
                    <div
                        class="zForm-wrap-checkbox py-11 px-16 bd-one bd-c-stroke-color bd-ra-8 bg-input-color">
                        <input class="form-check-input" type="radio" value="0" id="planPlanStatusInactive"
                               name="status" <?php echo e(isset($product->status) && $product->status == 1?'':'checked'); ?>/>
                        <label class="form-check-label" for="planPlanStatusInactive"><?php echo e(__("Inactive")); ?></label>
                    </div>
                </div>
            </div>

            <div class="d-flex align-items-center cg-10">
                <button type="submit" class="border-0 bd-ra-12 py-13 px-25 bg-main-color fs-16 fw-600 lh-19 text-white"><?php echo e(__("Submit Now")); ?></button>
                <button type="button"
                        class="border-0 bd-ra-12 py-13 px-25 bg-cancel-color fs-16 fw-600 lh-19 text-textBlack" data-bs-dismiss="modal"><?php echo e(__("Cancel Now")); ?></button>
            </div>
        </form>
<?php /**PATH /var/www/sub/resources/views/user/product/edit-form.blade.php ENDPATH**/ ?>