@extends('frontend.layouts.app')
@push('title')
    {{ __(@$pageTitle) }}
@endpush
@section('content')
    <!-- Modern Checkout Container -->
    <div class="min-vh-100 bg-light py-4 py-lg-5">
        <div class="container">
            <!-- Header with Logo -->
            <div class="text-center mb-4 mb-lg-5">
           
                    <img src="{{ getSettingImage('app_preloader') }}" alt="Logo" class="mb-3" style="max-height: 60px;">
         
           
                <p class="text-muted">Complete your purchase securely</p>
            </div>

            <form class="ajax" action="{{ route('checkout.order') }}" method="POST" data-handler="checkoutOrderResponse">
                @csrf
                <input type="hidden" id="selectGateway" name="gateway">
                <input type="hidden" id="selectCurrency" name="currency">
                <input type="hidden" value="{{ request()->route()->parameters('hash')['hash'] }}" name="checkout_details">

                <div class="row g-4">
                    <!-- Left Column - Forms -->
                    <div class="col-lg-8">
                        <!-- Basic Info Card -->
                        <div class="card border-0 shadow-sm mb-4">
                            <div class="card-body p-4">
                                <h5 class="card-title fw-bold mb-4">
                                    <i class="bi bi-person-circle me-2"></i>{{ __('Basic Information') }}
                                </h5>
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label class="form-label fw-semibold">{{ __('First Name') }}</label>
                                        <input type="text" name="basic_first_name" class="form-control form-control-lg" placeholder="John" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-semibold">{{ __('Last Name') }}</label>
                                        <input type="text" name="basic_last_name" class="form-control form-control-lg" placeholder="Doe" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-semibold">{{ __('Email') }}</label>
                                        <input type="email" name="basic_email" class="form-control form-control-lg" placeholder="john@example.com" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-semibold">{{ __('Phone') }}</label>
                                        <input type="text" name="basic_phone" class="form-control form-control-lg" placeholder="+1 234 567 8900" required>
                                    </div>
                                    
                                    @if (json_decode($checkoutPage?->basic_info))
                                        @foreach (json_decode($checkoutPage?->basic_info) ?? [] as $basicInfo)
                                            @if ($basicInfo->type == 'text' || $basicInfo->type == 'number' || $basicInfo->type == 'email')
                                                <div class="col-md-6">
                                                    <label class="form-label fw-semibold">{{ __($basicInfo->label) }}</label>
                                                    <input type="{{ $basicInfo->type }}" name="basic_info[{{ $basicInfo->name }}]" class="form-control form-control-lg" placeholder="{{ __($basicInfo->label) }}">
                                                </div>
                                            @elseif ($basicInfo->type == 'textarea')
                                                <div class="col-12">
                                                    <label class="form-label fw-semibold">{{ __($basicInfo->label) }}</label>
                                                    <textarea name="basic_info[{{ $basicInfo->name }}]" class="form-control" rows="3" placeholder="{{ __($basicInfo->label) }}"></textarea>
                                                </div>
                                            @endif
                                        @endforeach
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- Billing Info Card -->
                        <div class="card border-0 shadow-sm mb-4">
                            <div class="card-body p-4">
                                <h5 class="card-title fw-bold mb-4">
                                    <i class="bi bi-credit-card me-2"></i>{{ __('Billing Information') }}
                                </h5>
                                <div class="row g-3">
                                    <div class="col-12">
                                        <label class="form-label fw-semibold">{{ __('Address') }}</label>
                                        <input type="text" name="billing_address" class="form-control form-control-lg" placeholder="123 Main Street" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-semibold">{{ __('City') }}</label>
                                        <input type="text" name="billing_city" class="form-control form-control-lg" placeholder="New York" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-semibold">{{ __('State') }}</label>
                                        <input type="text" name="billing_state" class="form-control form-control-lg" placeholder="NY" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-semibold">{{ __('Zip Code') }}</label>
                                        <input type="text" name="billing_zip_code" class="form-control form-control-lg" placeholder="10001" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-semibold">{{ __('Country') }}</label>
                                        <input type="text" name="billing_country" class="form-control form-control-lg" placeholder="United States" required>
                                    </div>
                                    
                                    @if (json_decode($checkoutPage?->billing_info))
                                        @foreach (json_decode($checkoutPage?->billing_info) ?? [] as $billingInfo)
                                            @if ($billingInfo->type == 'text' || $billingInfo->type == 'number' || $billingInfo->type == 'email')
                                                <div class="col-md-6">
                                                    <label class="form-label fw-semibold">{{ __($billingInfo->label) }}</label>
                                                    <input type="{{ $billingInfo->type }}" name="billing_info[{{ $billingInfo->name }}]" class="form-control form-control-lg" placeholder="{{ __($billingInfo->label) }}">
                                                </div>
                                            @elseif ($billingInfo->type == 'textarea')
                                                <div class="col-12">
                                                    <label class="form-label fw-semibold">{{ __($billingInfo->label) }}</label>
                                                    <textarea name="billing_info[{{ $billingInfo->name }}]" class="form-control" rows="3" placeholder="{{ __($billingInfo->label) }}"></textarea>
                                                </div>
                                            @endif
                                        @endforeach
                                    @endif
                                </div>
                            </div>
                        </div> 

                        <!-- Payment Method Card -->
                   <div class="card border-0 shadow-sm mb-4" style="visibility: hidden;height:0px !important">
                            <div class="card-body p-4">
                                <h5 class="card-title fw-bold mb-4">
                                    <i class="bi bi-wallet2 me-2"></i>{{ __('Payment Method') }}
                                </h5>
                                <div class="row g-3 checkoutPaymentItem">
                                    @foreach ($gateways as $key => $gateway)
                                        @if (in_array($gateway->id, json_decode($checkoutPage?->payment) ?? []))
                                            <div class="col-6 col-md-4 col-lg-3">
                                                <input type="radio" class="btn-check paymentGateway" name="payment_gateway" id="gateway{{ $key }}" value="{{ $gateway->id }}" data-gateway="{{ $gateway->slug }}">
                                                <label class="btn btn-outline-dark w-100 h-100 d-flex align-items-center justify-content-center p-3" for="gateway{{ $key }}" style="min-height: 80px;">
                                                    <img src="{{ asset($gateway->image) }}" alt="{{ $gateway->name }}" class="img-fluid" style="max-height: 40px; max-width: 100%;">
                                                </label>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        </div>  

                        <!-- Bank Deposit Section (Hidden by default) -->
                        <div class="card border-0 shadow-sm mb-4 d-none" id="bankSection">
                            <div class="card-body p-4">
                                <h5 class="card-title fw-bold mb-4">
                                    <i class="bi bi-bank me-2"></i>{{ __('Bank Deposit') }}
                                </h5>
                                <div class="mb-3">
                                    <label class="form-label fw-semibold">{{ __('Bank Name') }}</label>
                                    <select class="form-select form-select-lg sf-select-two" id="bank_id" name="bank_id">
                                        <option value="">{{ __('Select Bank') }}</option>
                                        @foreach ($banks as $bank)
                                            <option value="{{ $bank->id }}" data-details="{{ nl2br($bank->details) }}">{{ $bank->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="alert alert-info d-none" id="bankDetails"></div>
                                <div>
                                    <label class="form-label fw-semibold">{{ __('Upload Deposit Slip') }}</label>
                                    <input type="file" class="form-control form-control-lg" id="bank_slip" name="bank_slip">
                                </div>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <button type="submit" class="btn btn-dark btn-lg w-100 py-3 fw-bold" id="paymentNowBtn">
                            <i class="bi bi-lock-fill me-2"></i>{{ __('Complete Payment') }} <span id="gatewayCurrencyAmount"></span>
                        </button>
                    </div>

                    <!-- Right Column - Order Summary -->
                    <div class="col-lg-4">
                        <div class="sticky-lg-top" style="top: 20px;">
                            <!-- Order Summary Card -->
                            <div class="card border-0 shadow-sm mb-4">
                                <div class="card-body p-4">
                                    <h5 class="card-title fw-bold mb-4">
                                        <i class="bi bi-receipt me-2"></i>{{ __('Order Summary') }}
                                    </h5>
                                    
                                    <div class="mb-3 pb-3 border-bottom">
                                        <h6 class="fw-bold text-dark mb-3">{{ $plan->name }}</h6>
                                        <div class="d-flex justify-content-between mb-2">
                                            <span class="text-muted">{{ __('Plan Code') }}</span>
                                            <span class="fw-semibold">{{ $plan->code }}</span>
                                        </div>
                                        <div class="d-flex justify-content-between mb-2">
                                            <span class="text-muted">{{ __('Quantity') }}</span>
                                            <span class="fw-semibold">1</span>
                                        </div>
                                        <div class="d-flex justify-content-between mb-2">
                                            <span class="text-muted">{{ __('Price') }}</span>
                                            <span class="fw-semibold">{{ showPrice($plan->price) }}</span>
                                        </div>
                                        <div class="d-flex justify-content-between mb-2">
                                            <span class="text-muted">{{ __('Setup Fee') }}</span>
                                            <span class="fw-semibold">{{ showPrice($plan->setup_fee) }}</span>
                                        </div>
                                    </div>

                                    <!-- Coupon Code -->
                                    <div class="mb-3 pb-3 border-bottom">
                                        <label class="form-label fw-semibold mb-2">{{ __('Discount Code') }}</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="coupon_code" id="couponCode" placeholder="Enter code">
                                            <button type="button" class="btn btn-outline-dark" id="couponCodeApplyBtn">{{ __('Apply') }}</button>
                                        </div>
                                    </div>

                                    <!-- Totals -->
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between mb-2">
                                            <span class="text-muted">{{ __('Discount') }}</span>
                                            <span class="fw-semibold text-success" id="discountShowAmount">$0.00</span>
                                        </div>
                                        <div class="d-flex justify-content-between mb-3">
                                            <span class="h6 mb-0 fw-bold">{{ __('Total') }}</span>
                                            <span class="h6 mb-0 fw-bold text-dark" id="totalShowAmount">{{ showPrice($plan->price + $plan->setup_fee + $plan->shipping_charge) }}</span>
                                        </div>
                                    </div>

                                    <div id="gatewayCurrencyAppend"></div>
                                </div>
                            </div>

                            <!-- Plan Details Card -->
                            @if($plan->details != null)
                                <div class="card border-0 shadow-sm">
                                    <div class="card-body p-4">
                                        <h5 class="card-title fw-bold mb-3">
                                            <i class="bi bi-info-circle me-2"></i>{{ __('Plan Details') }}
                                        </h5>
                                        <div class="text-muted small">
                                            {!! $plan->details !!}
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <input type="hidden" id="waitingRoute" value="{{ route('waiting') }}">
    <input type="hidden" id="planPrice" value="{{ $plan->price }}">
    <input type="hidden" id="planSetupFee" value="{{ $plan->setup_fee }}">
    <input type="hidden" id="planShippingCharge" value="{{ $plan->shipping_charge }}">
    <input type="hidden" id="discountAmount" value="0.00">
    <input type="hidden" id="planId" value="{{ $plan->id }}">
    <input type="hidden" id="userId" value="{{ $plan->user_id }}">
    <input type="hidden" id="getCouponInfoRoute" value="{{ route('get.coupon.info') }}">
    <input type="hidden" id="getCurrencyByGatewayRoute" value="{{ route('gateway.currency') }}">
@endsection

@push('style')
    <style>
        .zMain-checkout-content .title {
            font-size: {{ __($checkoutPage?->text_size) }};
            color: {{ __($checkoutPage?->text_color) }};
        }
        
        /* Custom Styles */
        .card {
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }
        
        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 0.5rem 1.5rem rgba(0,0,0,0.1) !important;
        }
        
        .btn-check:checked + .btn-outline-dark {
            background-color: #0d6efd;
            border-color: #0d6efd;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: #0d6efd;
            box-shadow: 0 0 0 0.25rem rgba(13,110,253,.25);
        }
        
        @media (max-width: 991.98px) {
            .sticky-lg-top {
                position: relative !important;
                top: 0 !important;
            }
        }
    </style>
@endpush

@push('script')
<script>
// Add this script AFTER checkout.js in your blade file
(function($) {
    "use strict";
    
    // Configuration
    const AUTO_SELECT_CONFIG = {
        gateway: 'paystack',  // Gateway slug to auto-select
        currency: 'GHS'       // Currency code to auto-select (GHS, NGN, USD, etc.)
    };
    
    // Function to select currency after it's loaded
    function autoSelectCurrency(targetCurrency) {
        const gatewayCurrencyAppend = $('#gatewayCurrencyAppend');
        
        if (gatewayCurrencyAppend.length === 0) return false;
        
        // Find the currency radio button
        const currencyLabels = gatewayCurrencyAppend.find('.form-check-label');
        let found = false;
        
        currencyLabels.each(function() {
            const labelText = $(this).text().trim();
            
            if (labelText === targetCurrency) {
                const radioId = $(this).attr('for');
                const radioButton = $('#' + radioId);
                
                if (radioButton.length) {
                    // Click the radio button
                    radioButton.prop('checked', true).trigger('click');
                    
                    // Update the hidden currency input
                    $('#selectCurrency').val(labelText);
                    
                    // Update the display text
                    const currencyValue = radioButton.val();
                    $('#gatewayCurrencyAmount').text('(' + currencyValue + ')');
                    
                    console.log('✓ Currency auto-selected:', targetCurrency, 'Value:', currencyValue);
                    found = true;
                    return false; // Break the loop
                }
            }
        });
        
        return found;
    }
    
    // Wait for DOM to be ready
    $(document).ready(function() {
        // Small delay to ensure checkout.js is fully initialized
        setTimeout(function() {
            // Find and click the target gateway
            const gateway = $('input[data-gateway="' + AUTO_SELECT_CONFIG.gateway + '"]');
            
            if (gateway.length) {
                console.log('✓ Auto-selecting gateway:', AUTO_SELECT_CONFIG.gateway);
                gateway.prop('checked', true).trigger('click');
                
                // Watch for currency options to be loaded
                // Use MutationObserver to detect when currencies are added to DOM
                const targetNode = document.getElementById('gatewayCurrencyAppend');
                
                if (targetNode) {
                    const observer = new MutationObserver(function(mutations) {
                        // Check if radio buttons were added
                        const hasRadios = $('#gatewayCurrencyAppend input[type="radio"]').length > 0;
                        
                        if (hasRadios) {
                            // Try to select currency
                            setTimeout(function() {
                                if (autoSelectCurrency(AUTO_SELECT_CONFIG.currency)) {
                                    observer.disconnect(); // Stop observing
                                }
                            }, 200);
                        }
                    });
                    
                    // Start observing
                    observer.observe(targetNode, {
                        childList: true,
                        subtree: true
                    });
                    
                    // Also try immediately in case it's already loaded
                    setTimeout(function() {
                        if (autoSelectCurrency(AUTO_SELECT_CONFIG.currency)) {
                            observer.disconnect();
                        }
                    }, 800);
                    
                    // Stop observing after 5 seconds to prevent memory leaks
                    setTimeout(function() {
                        observer.disconnect();
                        console.log('Auto-select observer stopped');
                    }, 5000);
                } else {
                    console.warn('gatewayCurrencyAppend element not found');
                }
            } else {
                console.warn('Gateway not found:', AUTO_SELECT_CONFIG.gateway);
                console.log('Available gateways:');
                $('input[data-gateway]').each(function() {
                    console.log(' -', $(this).data('gateway'));
                });
            }
        }, 500);
    });
    
})(jQuery);
    </script>
    <script src="{{ asset('user/custom/js/checkout.js') }}"></script>
@endpush