<div class="min-w-1100 px-20">
    <div class="d-flex justify-content-between align-items-start">
        <div class="d-flex align-items-start cg-47 rg-20 pb-30">
            <!-- Logo -->
            <a href="#" class="max-w-130">
                <img src="<?php echo e($invoiceSettingLogo??''); ?>" alt="" /></a>
            <!-- Info -->
            <div class="pl-sm-47 bd-sm-l-one bd-c-stroke-color">
                <?php echo $invoiceSettingCompanyInfo??''; ?>

            </div>
        </div>
        <button type="button"
            class="w-30 h-30 rounded-circle d-flex justify-content-center align-items-center bd-one bd-c-stroke-color bg-transparent"
            data-bs-dismiss="modal" aria-label="Close">
            <img src="<?php echo e(asset('assets/images/icon/close.svg')); ?>" alt="" />
        </button>
    </div>
    <!-- ID - Bill - Ship - Payment Method -->
    <div class="d-flex justify-content-between cg-10 pb-30">
        <!-- Id -->
        <div class="flex-shrink-0 max-w-206">
            <h4 class="fs-32 fw-600 lh-40 text-textBlack pb-10"><?php echo e($invoiceSettingTitle??''); ?></h4>
            <p class="fs-14 fw-400 lh-24 text-para-text"><?php echo e(__('No')); ?>

                : <?php echo e($invoiceInfo->invoice_id ?? 'N/A'); ?></p>
            <p class="fs-14 fw-400 lh-24 text-para-text"><?php echo e(__('Order Date ')); ?>

                : <?php echo e($invoiceInfo->created_at?->format('Y-m-d') ?? 'N/A'); ?></p>
        </div>
        <!-- Billed -->
        <div class="flex-shrink-0 max-w-206">
            <?php echo $invoiceSettingInfoOne??''; ?>

        </div>
        <!-- Shipped -->
        <div class="flex-shrink-0 max-w-206">
            <?php echo $invoiceSettingInfoTwo??''; ?>

        </div>

        <!-- Payment Method -->
        <div class="flex-shrink-0 max-w-206">
            <?php echo $invoiceSettingInfoThree??''; ?>

        </div>
    </div>
    <!-- Table -->
    <table class="table zTable zTable-last-item-right zTable-invoice">
        <thead>
            <tr>
                <th scope="col">
                    <div><?php echo e(__('SL')); ?></div>
                </th>
                <?php if(in_array(TABLE_COLUMN_PRODUCT, $invoiceSettingColumn ?? [])): ?>
                    <th scope="col">
                        <div><?php echo e(__('Product')); ?></div>
                    </th>
                <?php endif; ?>
                <?php if(in_array(TABLE_COLUMN_PLAN, $invoiceSettingColumn ?? [])): ?>
                    <th scope="col">
                        <div><?php echo e(__('Plan')); ?></div>
                    </th>
                <?php endif; ?>
                <?php if(in_array(TABLE_COLUMN_PRICE, $invoiceSettingColumn ?? [])): ?>
                    <th scope="col">
                        <div><?php echo e(__('Price')); ?></div>
                    </th>
                <?php endif; ?>
                <?php if(in_array(TABLE_SETUP_FEE, $invoiceSettingColumn ?? [])): ?>
                    <th scope="col">
                        <div><?php echo e(__('SetUp Fee')); ?></div>
                    </th>
                <?php endif; ?>
                <?php if(in_array(TABLE_COLUMN_QUANTITY, $invoiceSettingColumn ?? [])): ?>
                    <th scope="col">
                        <div><?php echo e(__('Quantity')); ?></div>
                    </th>
                <?php endif; ?>
                <?php if(in_array(TABLE_COLUMN_TOTAL, $invoiceSettingColumn ?? [])): ?>
                    <th scope="col">
                        <div><?php echo e(__('Total')); ?></div>
                    </th>
                <?php endif; ?>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>
                    <p><?php echo e(__('1')); ?></p>
                </td>
                <?php if(in_array(TABLE_COLUMN_PRODUCT, $invoiceSettingColumn ?? [])): ?>
                    <td>
                        <p class="fw-600 text-textBlack"><?php echo e($invoiceInfo->products_name ?? ''); ?></p>
                    </td>
                <?php endif; ?>
                <?php if(in_array(TABLE_COLUMN_PLAN, $invoiceSettingColumn ?? [])): ?>
                    <td>
                        <p><?php echo e($invoiceInfo->plans_name ?? ''); ?></p>
                    </td>
                <?php endif; ?>
                <?php if(in_array(TABLE_COLUMN_PRICE, $invoiceSettingColumn ?? [])): ?>
                    <td>
                        <p><?php echo e(showPrice($invoiceInfo->amount ?? 0)); ?></p>
                    </td>
                <?php endif; ?>
                <?php if(in_array(TABLE_SETUP_FEE, $invoiceSettingColumn ?? [])): ?>
                    <td>
                        <p><?php echo e(showPrice($invoiceInfo->setup_fees ?? 0)); ?></p>
                    </td>
                <?php endif; ?>
                <?php if(in_array(TABLE_COLUMN_QUANTITY, $invoiceSettingColumn ?? [])): ?>
                    <td>
                        <p>1</p>
                    </td>
                <?php endif; ?>
                <?php if(in_array(TABLE_COLUMN_TOTAL, $invoiceSettingColumn ?? [])): ?>
                    <td>
                        <p><?php echo e(showPrice(($invoiceInfo->amount ?? 0) + ($invoiceInfo->setup_fees ?? 0))); ?></p>
                    </td>
                <?php endif; ?>
            </tr>
        </tbody>
    </table>
    <!--  -->
    <div class="mt-18">
        <ul class="max-w-241 ms-auto pr-20">
            <li class="d-flex justify-content-between align-items-center cg-84 text-end">
                <p class="fs-14 fw-500 lh-17 text-para-text"><?php echo e(__('Subtotal')); ?>:</p>
                <p class="fs-14 fw-500 lh-17 text-textBlack"><?php echo e(showPrice(($invoiceInfo->amount ?? 0) + ($invoiceInfo->setup_fees ?? 0))); ?></p>
            </li>
            <li class="d-flex justify-content-between align-items-center cg-84 text-end">
                <p class="fs-14 fw-500 lh-17 text-para-text"><?php echo e(__('Discount')); ?>:</p>
                <p class="fs-14 fw-500 lh-17 text-textBlack"><?php echo e(showPrice($invoiceInfo->plan_discount ?? 0)); ?></p>
            </li>
            <li class="d-flex justify-content-between align-items-center text-end">
                <p class="fs-14 fw-500 lh-17 text-para-text"><?php echo e(__('Shipping Charge')); ?>:</p>
                <p class="fs-14 fw-500 lh-17 text-textBlack"><?php echo e(showPrice($invoiceInfo->order_shipping_cost ?? 0)); ?></p>
            </li>
            <li class="d-flex justify-content-between align-items-center text-end">
                <p class="fs-14 fw-500 lh-17 text-para-text"><?php echo e(__('Tax')); ?>:</p>
                <p class="fs-14 fw-500 lh-17 text-textBlack"><?php echo e(showPrice($invoiceInfo->order_tax_amount ?? 0)); ?></p>
            </li>
            <li class="d-flex justify-content-between align-items-center text-end">
                <p class="fs-14 fw-500 lh-17 text-para-text"><?php echo e(__('Total')); ?>:</p>
                <p class="fs-14 fw-500 lh-17 text-textBlack"><?php echo e(showPrice($invoiceInfo->total ?? 0)); ?></p>
            </li>
        </ul>
    </div>
    <div class="mb-15 mt-18">
        <?php if($invoiceInfo->payment_status == PAYMENT_STATUS_PAID): ?>
            <p><?php echo $invoiceSettingFooterText; ?></p>
        <?php endif; ?>
    </div>
    <!-- Buttons -->
    <div class="d-flex g-10">
        <a href="<?php echo e(route('user.invoice.download', encrypt($invoiceInfo->id))); ?>" target="_blank"
            class="border-0 bd-ra-8 py-13 px-25 bg-green fs-16 fw-600 lh-19 text-white"><?php echo e(__('Download')); ?></a>
    </div>

</div>
<?php /**PATH /var/www/sub/resources/views/user/invoice/invoice-view.blade.php ENDPATH**/ ?>