<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Konnected Academy - Design Your Future</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        
        * {
            font-family: 'Inter', sans-serif;
        }
        
     .gradient-bg {
    background: linear-gradient(rgba(0, 0, 0, 0.1), rgba(0, 0, 0, 0.1)), 
                url(https://konnectedacademy.com/wp-content/uploads/2025/01/KA-banner-kobyImg.png);
    background-size: contain;
    background-position: center;
    background-repeat: no-repeat;
    background-color: #000;
}
        
        .card-hover {
            transition: all 0.3s ease;
        }
        
        .card-hover:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
        }
        
        .feature-icon {
            transition: all 0.3s ease;
        }
        
        .feature-item:hover .feature-icon {
            transform: scale(1.1);
            color: #3b82f6;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(59, 130, 246, 0.4);
        }
        
        .popular-badge {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
        }
        
        .animate-fade-in {
            animation: fadeIn 0.8s ease-in;
        }
        
      
        
        .text-gradient {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Header -->
    <header class="bg-black text-white py-4 sticky top-0 z-50 shadow-lg">
        <div class="container mx-auto px-6 flex justify-between items-center">
            <div class="flex items-center space-x-3">
                <!-- REPLACE THIS WITH YOUR LOGO URL -->
                <img src="https://konnectedacademy.com/wp-content/uploads/2025/01/konnectedAcademy-realLogo.png" alt="Konnected Academy Logo" class="h-10 w-auto">
                <!-- If you don't have a logo yet, uncomment the line below and delete the img tag above -->
                <!-- <i class="fas fa-link text-2xl text-blue-400"></i>
                <h1 class="text-2xl font-bold">Konnected Academy</h1> -->
            </div>
            <nav class="hidden md:flex space-x-6">
                <a href="#about" class="hover:text-blue-400 transition">About</a>
                <a href="#features" class="hover:text-blue-400 transition">Features</a>
                <a href="#pricing" class="hover:text-blue-400 transition">Pricing</a>
            </nav>
        </div>
    </header>

    <!-- Hero Section -->
    <section class="gradient-bg text-white py-20 animate-fade-in">
        <div class="container mx-auto px-6 text-center">
            <h2 class="text-5xl md:text-6xl font-bold mb-6">Design a Life Aligned with<br>Your Goals and Passions</h2>
            <p class="text-xl md:text-2xl text-gray-300 mb-8 max-w-3xl mx-auto">
                Master mindset, build wealth, and connect with a like-hearted community of growth-minded individuals.
            </p>
            <a href="#pricing" class="btn-primary text-white px-8 py-4 rounded-full text-lg font-semibold inline-block">
                Start Your Journey <i class="fas fa-arrow-right ml-2"></i>
            </a>
        </div>
    </section>

    <!-- About Section -->
    <section id="about" class="py-20 bg-white">
        <div class="container mx-auto px-6">
            <div class="max-w-6xl mx-auto">
                <div class="grid md:grid-cols-2 gap-12 items-center">
                    <div>
                        <h3 class="text-4xl font-bold text-gray-900 mb-6">
                            Who Is <span class="text-gradient">Konnected Academy</span> For?
                        </h3>
                        <p class="text-lg text-gray-600 mb-6">
                            Konnected Academy is for growth-minded individuals who want to master mindset, build wealth, and connect with a like-hearted community. Whether you're starting your journey or already building something great, this space will help you go further—with clarity, purpose, and real support.
                        </p>
                        <p class="text-gray-700 font-semibold mb-4">Created and hosted by Derrick Abaitey</p>
                        <p class="text-gray-600">Entrepreneur, Podcast Host, and Mentor helping ambitious people crush limiting beliefs and build unstoppable confidence.</p>
                    </div>
                    <div class="relative">
                        <!-- REPLACE WITH DERRICK'S IMAGE URL -->
                   
                      
                        <img src="https://konnectedacademy.com/wp-content/uploads/2025/03/DerrickAbaitey-new-scaled.jpg" alt="Derrick Abaitey" class="rounded-2xl shadow-2xl w-full h-auto">
                     
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="py-20 bg-gray-50">
        <div class="container mx-auto px-6">
            <h3 class="text-4xl font-bold text-center text-gray-900 mb-16">What You'll Get Inside</h3>
            
            <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-8 max-w-6xl mx-auto">
                <div class="feature-item text-center p-6 bg-white rounded-xl shadow-sm hover:shadow-md transition">
                    <div class="feature-icon text-5xl mb-4">
                        <i class="fas fa-brain text-gray-700"></i>
                    </div>
                    <h4 class="text-xl font-semibold text-gray-900 mb-3">Weekly Content</h4>
                    <p class="text-gray-600">Deep insights on mindset and business to accelerate your growth</p>
                </div>

                <div class="feature-item text-center p-6 bg-white rounded-xl shadow-sm hover:shadow-md transition">
                    <div class="feature-icon text-5xl mb-4">
                        <i class="fas fa-users text-gray-700"></i>
                    </div>
                    <h4 class="text-xl font-semibold text-gray-900 mb-3">Supportive Community</h4>
                    <p class="text-gray-600">Connect with ambitious learners on the same journey</p>
                </div>

                <div class="feature-item text-center p-6 bg-white rounded-xl shadow-sm hover:shadow-md transition">
                    <div class="feature-icon text-5xl mb-4">
                        <i class="fas fa-tools text-gray-700"></i>
                    </div>
                    <h4 class="text-xl font-semibold text-gray-900 mb-3">Tools & Resources</h4>
                    <p class="text-gray-600">Practical insights and inspiration for personal and professional growth</p>
                </div>

                <div class="feature-item text-center p-6 bg-white rounded-xl shadow-sm hover:shadow-md transition">
                    <div class="feature-icon text-5xl mb-4">
                        <i class="fas fa-crown text-gray-700"></i>
                    </div>
                    <h4 class="text-xl font-semibold text-gray-900 mb-3">Exclusive Access</h4>
                    <p class="text-gray-600">Inner Circle content, behind-the-scenes, and uncut podcast moments</p>
                </div>
            </div>
        </div>
    </section>

    <!-- You'll Vibe Here If Section -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-6">
            <div class="max-w-4xl mx-auto">
                <h3 class="text-4xl font-bold text-center text-gray-900 mb-12">You'll Vibe Here If You:</h3>
                
                <div class="space-y-6">
                    <div class="flex items-start space-x-4 p-6 bg-gray-50 rounded-xl">
                        <div class="flex-shrink-0">
                            <i class="fas fa-check-circle text-3xl text-blue-600"></i>
                        </div>
                        <div>
                            <h4 class="text-xl font-semibold text-gray-900 mb-2">Want to grow, but not alone</h4>
                            <p class="text-gray-600">Join a community of like-minded individuals who support and inspire each other</p>
                        </div>
                    </div>

                    <div class="flex items-start space-x-4 p-6 bg-gray-50 rounded-xl">
                        <div class="flex-shrink-0">
                            <i class="fas fa-check-circle text-3xl text-blue-600"></i>
                        </div>
                        <div>
                            <h4 class="text-xl font-semibold text-gray-900 mb-2">Value purpose, not just profit</h4>
                            <p class="text-gray-600">Build a meaningful life aligned with your deeper goals and values</p>
                        </div>
                    </div>

                    <div class="flex items-start space-x-4 p-6 bg-gray-50 rounded-xl">
                        <div class="flex-shrink-0">
                            <i class="fas fa-check-circle text-3xl text-blue-600"></i>
                        </div>
                        <div>
                            <h4 class="text-xl font-semibold text-gray-900 mb-2">Believe your mindset is your greatest asset</h4>
                            <p class="text-gray-600">Transform your thinking patterns to unlock your full potential</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Pricing Section -->
    <!-- Pricing Section -->
<section id="pricing" class="py-20 bg-gray-50">
    <div class="container mx-auto px-6">
        <h3 class="text-4xl font-bold text-center text-gray-900 mb-4">Choose Your Path</h3>
        <p class="text-center text-gray-600 mb-16 text-lg">Invest in yourself and start building the life you deserve</p>
        
        <div class="grid md:grid-cols-2 gap-8 max-w-5xl mx-auto">
            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-white rounded-2xl shadow-lg p-8 card-hover relative <?php echo e($plan->code === 'YEARLY' ? 'border-2 border-blue-500' : ''); ?>">
                    
                    <?php if($plan->code === 'YEARLY'): ?>
                        <div class="absolute top-0 right-0 popular-badge text-white px-6 py-2 rounded-bl-2xl rounded-tr-2xl font-semibold text-sm">
                            <i class="fas fa-star mr-1"></i> BEST VALUE
                        </div>
                    <?php endif; ?>
                    
                    <div class="text-center mb-8 <?php echo e($plan->code === 'YEARLY' ? 'mt-4' : ''); ?>">
                        <div class="inline-block p-4 <?php echo e($plan->code === 'YEARLY' ? 'bg-blue-50' : 'bg-gray-100'); ?> rounded-full mb-4">
                            <i class="fas <?php echo e($plan->code === 'MONTHLY' ? 'fa-calendar-alt' : 'fa-calendar-check'); ?> text-4xl <?php echo e($plan->code === 'YEARLY' ? 'text-blue-600' : 'text-gray-700'); ?>"></i>
                        </div>
                        <h4 class="text-3xl font-bold text-gray-900 mb-2"><?php echo e($plan->name); ?></h4>
                        <p class="text-gray-600">
                            <?php if($plan->code === 'MONTHLY'): ?>
                                Perfect for getting started
                            <?php else: ?>
                                Save <?php echo e(round((1 - ($plan->price / (9 * 12))) * 100)); ?>% with annual billing
                            <?php endif; ?>
                        </p>
                    </div>
                    
                    <div class="mb-8">
                        <div class="flex items-baseline justify-center mb-6">
                            <span class="text-5xl font-bold text-gray-900">$<?php echo e(number_format($plan->price, 2)); ?></span>
                            <span class="text-gray-600 ml-2">/<?php echo e($plan->code === 'MONTHLY' ? 'month' : 'year'); ?></span>
                        </div>
                        <?php if($plan->code === 'YEARLY'): ?>
                            <p class="text-center text-blue-600 font-semibold">
                                Save $<?php echo e(number_format((9 * 12) - $plan->price, 2)); ?> compared to monthly
                            </p>
                        <?php endif; ?>
                    </div>

                    <ul class="space-y-4 mb-8">
                        <?php if($plan->code === 'MONTHLY'): ?>
                            <li class="flex items-start">
                                <i class="fas fa-check text-blue-600 mt-1 mr-3"></i>
                                <span class="text-gray-700">Full access to all content</span>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-check text-blue-600 mt-1 mr-3"></i>
                                <span class="text-gray-700">Community support</span>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-check text-blue-600 mt-1 mr-3"></i>
                                <span class="text-gray-700">Weekly content updates</span>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-check text-blue-600 mt-1 mr-3"></i>
                                <span class="text-gray-700">Exclusive Inner Circle access</span>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-check text-blue-600 mt-1 mr-3"></i>
                                <span class="text-gray-700">Cancel anytime</span>
                            </li>
                        <?php else: ?>
                            <li class="flex items-start">
                                <i class="fas fa-check text-blue-600 mt-1 mr-3"></i>
                                <span class="text-gray-700">Everything in Monthly</span>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-check text-blue-600 mt-1 mr-3"></i>
                                <span class="text-gray-700"><strong>Save <?php echo e(round((1 - ($plan->price / (9 * 12))) * 100)); ?>% annually</strong></span>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-check text-blue-600 mt-1 mr-3"></i>
                                <span class="text-gray-700">Priority support</span>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-check text-blue-600 mt-1 mr-3"></i>
                                <span class="text-gray-700">Bonus resources & templates</span>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-check text-blue-600 mt-1 mr-3"></i>
                                <span class="text-gray-700">Early access to new features</span>
                            </li>
                        <?php endif; ?>
                    </ul>

                    <a href="<?php echo e(route('checkout', encrypt(['plan_id' => $plan->id, 'user_id' => $plan->user_id]))); ?>" class="block w-full <?php echo e($plan->code === 'YEARLY' ? 'btn-primary' : 'bg-gray-900 hover:bg-gray-800'); ?> text-white text-center py-4 rounded-full font-semibold transition">
    Get Started <i class="fas fa-arrow-right ml-2"></i>
</a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

    <!-- CTA Section -->
    <section class="gradient-bg text-white py-20">
        <div class="container mx-auto px-6 text-center">
            <h3 class="text-4xl md:text-5xl font-bold mb-6">Ready to Transform Your Life?</h3>
            <p class="text-xl text-gray-300 mb-8 max-w-2xl mx-auto">
                Join a community of ambitious individuals committed to growth, wealth, and purpose.
            </p>
            <a href="#pricing" class="bg-white text-gray-900 px-8 py-4 rounded-full text-lg font-semibold inline-block hover:bg-gray-100 transition">
                Let's Konnect <i class="fas fa-link ml-2"></i>
            </a>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-gray-900 text-gray-400 py-12">
        <div class="container mx-auto px-6">
            <div class="text-center">
                <div class="flex items-center justify-center space-x-3 mb-4">
                    <!-- REPLACE THIS WITH YOUR LOGO URL -->
                    <img src="https://konnectedacademy.com/wp-content/uploads/2025/01/konnectedAcademy-realLogo.png" alt="Konnected Academy Logo" class="h-8 w-auto">
                    <!-- If you don't have a logo yet, uncomment the line below and delete the img tag above -->
                    <!-- <i class="fas fa-link text-2xl text-blue-400"></i>
                    <h4 class="text-2xl font-bold text-white">Konnected Academy</h4> -->
                </div>
                <p class="mb-6">Design a life aligned with your goals and passions</p>
                <div class="flex justify-center space-x-6 mb-6">
                    <a href="#" class="hover:text-blue-400 transition"><i class="fab fa-facebook text-2xl"></i></a>
                    <a href="#" class="hover:text-blue-400 transition"><i class="fab fa-instagram text-2xl"></i></a>
                    <a href="#" class="hover:text-blue-400 transition"><i class="fab fa-twitter text-2xl"></i></a>
                    <a href="#" class="hover:text-blue-400 transition"><i class="fab fa-linkedin text-2xl"></i></a>
                </div>
                <p class="text-sm">&copy; 2025 Konnected Academy. All rights reserved.</p>
            </div>
        </div>
    </footer>
</body>
</html><?php /**PATH /var/www/sub/resources/views/index.blade.php ENDPATH**/ ?>