<!-- Header -->
<div class="d-flex justify-content-between align-items-center cg-10 pb-16">
    <h4 class="fs-18 fw-600 lh-24 text-textBlack"><?php echo e(__("Transaction Details")); ?></h4>
    <button type="button"
            class="w-30 h-30 rounded-circle d-flex justify-content-center align-items-center bd-one bd-c-stroke-color bg-transparent"
            data-bs-dismiss="modal" aria-label="Close"><img src="<?php echo e(asset('user/images/icon/close.svg')); ?>" alt=""/>
    </button>
</div>

<hr>
<div class="table-responsive">
    <table class="table bg-light ">
        <thead>
        <tr>
            <th scope="col"><div class="min-w-100"><?php echo e(__('Date')); ?></div></th>
            <th scope="col"><div class="min-w-100"><?php echo e(__('Gateway')); ?></div></th>
            <th scope="col"><div class="min-w-150"><?php echo e(__('Transaction ID')); ?></div></th>
            <th scope="col"><div class="min-w-100"><?php echo e(__('Amount')); ?></div></th>
            <th scope="col"><div class="min-w-100"><?php echo e(__('Action')); ?></div></th>
        </tr>
        </thead>
        <tbody class="table-group-divider ">
        <tr>
            <td><?php echo e(date('d-m-Y', strtotime($order->created_at))); ?></td>
            <td><?php echo e($order->gateway->title); ?></td>
            <td><?php echo e($order->transaction_id ? $order->transaction_id : 'N/A'); ?></td>
            <td><?php echo e($order->total); ?></td>
            <td>
                <?php if($order->payment_status == PAYMENT_STATUS_PAID): ?>
                    <p class='zBadge zBadge-success'><?php echo e(__('Paid')); ?></p>
                <?php elseif($order->payment_status == PAYMENT_STATUS_PENDING): ?>
                    <p class="zBadge zBadge-pending"><?php echo e(__('Pending')); ?></p>
                <?php elseif($order->payment_status == PAYMENT_STATUS_CANCELLED): ?>
                    <p class='zBadge zBadge-fuilure'><?php echo e(__('Cancel')); ?></p>
                <?php endif; ?>
            </td>
        </tr>
        </tbody>
    </table>
</div>
<!-- Body -->
<?php /**PATH /var/www/sub/resources/views/user/order/order_show.blade.php ENDPATH**/ ?>