
<?php $__env->startSection('content'); ?>
    <?php $__env->startPush('title'); ?>
        <?php echo e($title); ?>

    <?php $__env->stopPush(); ?>
    <!-- Page content area start -->
    <div class="p-30">
        <div class="">
            <h4 class="fs-24 fw-500 lh-34 text-black pb-16"><?php echo e(__($title)); ?></h4>
            <div class="row">
                <div class="col-lg-12 col-md-12 bg-white bd-half bd-c-ebedf0 bd-ra-25 p-30">
                    <div class="table-responsive zTable-responsive">
                        <table class="table zTable">
                            <thead>
                                <tr>
                                    <th>
                                        <div><?php echo e(__('SL')); ?></div>
                                    </th>
                                    <th>
                                        <div><?php echo e(__('Image')); ?></div>
                                    </th>
                                    <th>
                                        <div><?php echo e(__('Title')); ?></div>
                                    </th>
                                    <th>
                                        <div><?php echo e(__('Slug')); ?></div>
                                    </th>
                                    <th>
                                        <div><?php echo e(__('Status')); ?></div>
                                    </th>
                                    <th>
                                        <div><?php echo e(__('Mode')); ?></div>
                                    </th>
                                    <th>
                                        <div><?php echo e(__('Action')); ?></div>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td>
                                            <div class="">
                                                <div class="btn btn-dropdown site-language">
                                                    <img src="<?php echo e(asset($gateway->image)); ?>" class="gateway-image"
                                                        alt="">
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo e($gateway->title); ?></td>
                                        <td><?php echo e($gateway->slug); ?></td>
                                        <td>
                                            <?php if($gateway->status == ACTIVE): ?>
                                                <div class="status-btn status-btn-green font-13 radius-4">
                                                    <?php echo e(__('Active')); ?></div>
                                            <?php else: ?>
                                                <div class="status-btn status-btn-orange font-13 radius-4">
                                                    <?php echo e(__('Deactive')); ?></div>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($gateway->mode == GATEWAY_MODE_LIVE): ?>
                                                <div class="status-btn status-btn-green font-13 radius-4">
                                                    <?php echo e(__('Live')); ?></div>
                                            <?php elseif($gateway->slug != 'bank'): ?>
                                                <div class="status-btn status-btn-orange font-13 radius-4">
                                                    <?php echo e(__('Sandbox')); ?></div>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <button type="button" class=" bg-f9f9f9 border-0 btn-action mr-1 edit"
                                                data-toggle="tooltip" title="<?php echo e(__('Edit')); ?>"
                                                data-id="<?php echo e($gateway->id); ?>">
                                                <img src="<?php echo e(asset('assets/images/icon/edit.svg')); ?>" alt="edit">
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Page content area end -->
    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header p-20 border-0 pb-0">
                    <h4 class="modal-title fs-18 fw-600 lh-24 text-1b1c17" id="editModalLabel"><?php echo e(__('Edit Gateway')); ?>

                    </h4>
                    <button type="button" class="w-30 h-30 rounded-circle bd-one bd-c-e4e6eb p-0 bg-transparent"
                        data-bs-dismiss="modal" aria-label="Close"><i class="fa-solid fa-times"></i></button>
                </div>
                <form class="ajax" action="<?php echo e(route('admin.setting.gateway.store')); ?>" method="POST"
                    data-handler="responseOnGatewaStore">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" id="id" required>
                    <div class="modal-body">
                        <h4 class="fs-18 fw-600 lh-24 text-1b1c17 mb-10"><?php echo e(__('Gateway')); ?></h4>
                        <div class="modal-inner-form-box bg-off-white theme-border radius-4">
                            <div class="row">
                                <div class="upload-profile-photo-box mb-10">
                                    <div class="profile-user position-relative d-inline-block">
                                        <img src="" class="image" alt="">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="primary-form-group mt-2">
                                        <div class="primary-form-group-wrap">
                                            <label
                                                class="label-text-title color-heading font-medium mb-2 form-label"><?php echo e(__('Title')); ?></label>
                                            <input type="text" class="primary-form-control title" readonly>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="primary-form-group mt-2">
                                            <div class="primary-form-group-wrap">
                                                <label
                                                    class="label-text-title color-heading font-medium mb-2 form-label"><?php echo e(__('Title')); ?></label>
                                                <input type="text" class="primary-form-control title" readonly>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="primary-form-group mt-2">
                                            <div class="primary-form-group-wrap">
                                                <label
                                                    class="label-text-title color-heading font-medium mb-2 form-label"><?php echo e(__('Slug')); ?></label>
                                                <input type="text" name="slug" class="primary-form-control slug"
                                                    readonly>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="primary-form-group mt-2">
                                            <div class="primary-form-group-wrap">
                                                <label
                                                    class="label-text-title color-heading font-medium mb-2 form-label"><?php echo e(__('Status')); ?></label>
                                                <select name="status" id="status"
                                                    class="primary-form-control sf-select-without-search">
                                                    <option value="0"><?php echo e(__('Deactive')); ?></option>
                                                    <option value="1"><?php echo e(__('Active')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mode-div">
                                        <div class="primary-form-group mt-2">
                                            <div class="primary-form-group-wrap">
                                                <label
                                                    class="label-text-title color-heading font-medium mb-2 form-label"><?php echo e(__('Mode')); ?></label>
                                                <select name="mode" id="mode"
                                                    class="primary-form-control sf-select-without-search">
                                                    <option value="1"><?php echo e(__('Live')); ?></option>
                                                    <option value="2"><?php echo e(__('Sandbox')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="bank-div">
                                    <div class="bank-div-append">

                                    </div>
                                    <div class="row mb-20">
                                        <div class="col-12 text-end">
                                            <button type="button"
                                                class="fs-15 fw-500 lh-25 border-0 text-white py-10 px-26 bg-7f56d9 bd-ra-12 ml-10 border-0 green-color add-bank"
                                                title="<?php echo e(__('Add Bank')); ?>">
                                                <span class="iconify" data-icon="material-symbols:add"></span>
                                                <?php echo e(__('Add Bank')); ?></button>
                                        </div>
                                    </div>
                                </div>

                                <div class="row url-div">
                                    <div class="col-md-12 gateway-input" id="gateway-url">
                                        <div class="primary-form-group mt-2">
                                            <div class="primary-form-group-wrap">
                                                <label
                                                    class="label-text-title color-heading font-medium mb-2 form-label"><?php echo e(__('Url')); ?>

                                                    /<?php echo e(__('Hash')); ?></label>
                                                <input class="primary-form-control" type="text" name="url">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row key-secret-div">
                                    <div class="col-md-12 mb-10 gateway-input" id="gateway-key">
                                        <div class="primary-form-group mt-2">
                                            <div class="primary-form-group-wrap">
                                                <label
                                                    class="label-text-title color-heading font-medium mb-2 form-label"><?php echo e(__('Key')); ?></label>
                                                <input class="primary-form-control" type="text" name="key">
                                            </div>
                                        </div>
                                        <small
                                            class="d-none small"><?php echo e(__('Client id, Public Key, Key, Store id, Api Key')); ?></small>
                                    </div>
                                    <div class="col-md-12 mb-10 gateway-input" id="gateway-secret">
                                        <div class="primary-form-group mt-2">
                                            <div class="primary-form-group-wrap">
                                                <label
                                                    class="label-text-title color-heading font-medium mb-2 form-label"><?php echo e(__('Secret')); ?></label>
                                                <input class="primary-form-control" type="text" name="secret">
                                            </div>
                                        </div>
                                        <small
                                            class="d-none small"><?php echo e(__('Client Secret, Secret, Store Password, Auth Token')); ?></small>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <label
                                            class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Conversion Rate')); ?>

                                            <button type="button"
                                                class="add-currency bd-ra-12 bg-e4e6eb border-0 edit-btn fs-15 fw-500 lh-25 ml-10fs-15 text-black"><svg
                                                    xmlns="http://www.w3.org/2000/svg" width="21" height="21"
                                                    viewBox="0 0 21 21">
                                                    <path fill="none" stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" d="M5.5 10.5h10m-5-5v10" />
                                                </svg></span>
                                            </button>
                                        </label>
                                        <div id="currencyConversionRateSection"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer justify-content-start  border-0 p-0 g-10">
                            <button type="button"
                                class="m-0 fs-15 fw-500 lh-25 border-0 text-black py-10 px-26 bg-e4e6eb hover-bg-three hover-color-white bd-ra-12"
                                data-bs-dismiss="modal" title="<?php echo e(__('Back')); ?>"><?php echo e(__('Back')); ?></button>
                            <button type="submit"
                                class="m-0 fs-15 fw-500 lh-25 border-0 text-white py-10 px-26 bg-7f56d9 bd-ra-12 ml-10"
                                title="<?php echo e(__('Submit')); ?>"><?php echo e(__('Update')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <input type="hidden" id="getInfoRoute" value="<?php echo e(route('admin.setting.gateway.get.info')); ?>">
    <input type="hidden" id="getCurrencySymbol" value="<?php echo e(getCurrencySymbol()); ?>">
    <input type="hidden" id="allCurrency" value="<?php echo e(json_encode(getCurrency())); ?>">
    <input type="hidden" id="gatewaySettings" value="<?php echo e(gatewaySettings()); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('admin/js/gateway.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sub/resources/views/admin/setting/gateway.blade.php ENDPATH**/ ?>