<?php

namespace App\Http\Controllers;

use App\Http\Requests\User\WebhookRequest;
use App\Http\Services\GatewayService;
use App\Http\Services\PlanService;
use App\Http\Services\SettingsService;
use App\Models\Webhook;
use App\Traits\ResponseTrait;
use Illuminate\Http\Request;
// use Illuminate\Support\Facades\DB;
// use Mockery\Exception;
use App\Models\{User, UserDetails, Plan, Subscription, Order};
use App\Http\Services\InvoiceService;
use Illuminate\Support\Facades\{DB, Hash};
use Exception;
class WebhookController extends Controller
{
    use ResponseTrait;


    public $planService, $settingsService, $gatewayService;

    public function __construct()
    {
        $this->planService = new PlanService();
        $this->settingsService = new SettingsService();
        $this->gatewayService = new GatewayService();
    }

    public function webhookList(Request $request){

        if ($request->ajax()) {
            $tax = Webhook::where('user_id', auth()->id())->with(['plan', 'product']);
            return datatables($tax)
                ->addIndexColumn()

                ->addColumn('product_name', function ($data) {
                    return htmlspecialchars($data->product->name);
                })

                ->addColumn('plan_name', function ($data) {
                    return htmlspecialchars($data->plan->name);
                })

                ->addColumn('status', function ($data) {
                    if ($data->status == STATUS_ACTIVE) {
                        return '<span class="zBadge-free">Active</span>';
                    } else {
                        return '<span class="zBadge-free">Inactive</span>';
                    }
                })
                ->addColumn('action', function ($data){
                    return '<ul class="d-flex align-items-center cg-5 justify-content-center">
                            <li class="d-flex gap-2">
                                <button onclick="getEditModal(\'' . route('user.webhook.edit', $data->id) . '\'' . ', \'#edit-webhook-modal\')" class="d-flex justify-content-center align-items-center w-30 h-30 rounded-circle bd-one border-0 bd-c-ededed bg-white" data-bs-toggle="modal" data-bs-target="#alumniPhoneNo" title="Edit">
                                    <img src="' . asset('assets/images/icon/edit.svg') . '" alt="edit" />
                                </button>
                                <button onclick="deleteItem(\'' . route('user.webhook.delete', $data->id) . '\', \'webhookTable\')" class="d-flex justify-content-center align-items-center w-30 h-30 rounded-circle border-0 bd-one bd-c-ededed bg-white" title="Delete">
                                    <img src="' . asset('assets/images/icon/delete-1.svg') . '" alt="delete">
                                </button>
                            </li>
                        </ul>';
                })
                ->rawColumns(['status', 'action'])
                ->make(true);
        }
    }
    public function webhookStore(WebhookRequest $request){
        try {
            DB::beginTransaction();
            if(isset($request->id)){
                $data = Webhook::find($request->id);
                $msg = UPDATED_SUCCESSFULLY;
            }else{
                $data = new Webhook();
                $msg = CREATED_SUCCESSFULLY;
            }

            $data->webhook_name = $request->webhook_name;
            $data->product_id = $request->product_id;
            $data->plan_id = $request->plan_id;
            $data->webhook_url = $request->webhook_url;
            $data->user_id = auth()->id();
            $data->status = STATUS_ACTIVE;
            $data->save();
            DB::commit();
            return $this->success([], getMessage($msg));
        }catch (Exception $exception){
            DB::rollBack();
            return $this->error([], getMessage(SOMETHING_WENT_WRONG));
        }
    }

    public function deleteWebhook($id){
        try {
            $event = Webhook::where('id', $id)->first();
            $event->delete();
            $message = getMessage(DELETED_SUCCESSFULLY);
            return $this->success([], $message);
        } catch (\Exception $e) {
            $message = getErrorMessage($e, $e->getMessage());
            return $this->error([], $message);
        }
    }

    public function webhookEdit($id)
    {
        try {
            $data['webhook'] = Webhook::find($id);
            if (is_null($data['webhook'])){
                return $this->error([], getMessage(SOMETHING_WENT_WRONG));
            }
            $data['allProducts'] = $this->settingsService->getAllProduct();
            $data['planList'] = $this->planService->planListByProductId($data['webhook']->product_id);
            return view('user.settings.webhook.edit-form', $data)->render();
        }catch (Exception $exception){
            return $this->error([], getMessage(SOMETHING_WENT_WRONG));
        }
    }

    
public function handleSkool(Request $request)
{
    DB::beginTransaction();
    try {
        $data = $request->all();
        
        \Log::info($data);
        
        // Check if user exists
        $user = User::where('email', $data['email'])->first();
        
        if (!$user) {
            // Create user
            $user = new User();
            $user->uuid = \Str::uuid();
            $user->name = ($data['first_name'] ?? '') . ' ' . ($data['last_name'] ?? '');
            $user->email = $data['email'] ?? null;
            $user->password = Hash::make(\Str::random(16));
            $user->role = USER_ROLE_CUSTOMER;
            $user->status = STATUS_ACTIVE;
            $user->email_verification_status = 1;
            $user->created_by = 2; // Your user ID
            $user->save();
            
            // Store in user_details
            UserDetails::create([
                'user_id' => $user->id,
                'basic_first_name' => $data['first_name'] ?? null,
                'basic_last_name' => $data['last_name'] ?? null,
                'basic_email' => $data['email'] ?? null,
                'basic_info' => json_encode($data),
            ]);
        }
        
        // Get plan (adjust plan_id as needed)
        $plan = Plan::where('user_id', 2)->find(2);
        
        if (!$plan) {
            throw new Exception('Plan not found');
        }
        
        // Create subscription
        $subscription = new Subscription();
        $subscription->product_id = $plan->product_id;
        $subscription->plan_id = $plan->id;
        $subscription->subscription_id = uniqid();
        $subscription->user_id = 2; // Your user ID
        $subscription->customer_id = $user->id;
        $subscription->due_day = $plan->due_day;
        $subscription->amount = 0.00; // Free from Skool
        $subscription->status = STATUS_ACTIVE;
        $subscription->free_trail = $plan->free_trail;
        $subscription->setup_fee = 0;
        $subscription->shipping_charge = 0;
        $subscription->billing_cycle = $plan->billing_cycle;
        $subscription->bill = $plan->bill;
        $subscription->duration = $plan->duration;
        $subscription->start_date = date('Y-m-d');
        $subscription->number_of_recurring_cycle = $plan->number_of_recurring_cycle;
        $subscription->save();
        
        // Create invoice
        $invoiceService = new InvoiceService();
        $invoice = $invoiceService->makeInvoice(1, $subscription->id);
        
        // Create order
        $order = new Order();
        $order->user_id = 2; // Your user ID
        $order->order_id = uniqid();
        $order->customer_id = $user->id;
        $order->product_id = $plan->product_id;
        $order->plan_id = $plan->id;
        $order->invoice_id = $invoice->id;
        $order->gateway_id = 17; // Your gateway ID
        $order->subscription_id = $subscription->id;
        $order->payment_id = uniqid('SKL');
        $order->amount = 0.00;
        $order->discount = 0.00;
        $order->discount_type = DISCOUNT_TYPE_FLAT;
        $order->shipping_cost = 0.00;
        $order->setup_fees = 0.00;
        $order->tax_amount = 0.00;
        $order->tax_type = TAX_TYPE_FLAT;
        $order->conversion_rate = 1.00;
        $order->subtotal = 0.00;
        $order->total = 0.00;
        $order->transaction_amount = 0.00;
        $order->payment_status = PAYMENT_STATUS_PAID;
        $order->delivery_status = 2; // Delivered
        $order->system_currency = 'USD';
        $order->gateway_currency = 'USD';
        $order->save();
        
        DB::commit();
        return response()->json(['status' => 'success']);
        
    } catch (Exception $e) {
        DB::rollBack();
        \Log::error('Skool webhook error: ' . $e->getMessage());
        return response()->json(['status' => 'error', 'message' => $e->getMessage()], 500);
    }
}
}
