<?php
namespace App\Http\Controllers;

use App\Http\Services\Payment\Payment;
use App\Http\Services\SettingsService;
use App\Models\Gateway;
use App\Models\Invoice;
use App\Models\License;
use App\Models\Order;
use App\Models\Subscription;
use App\Traits\ResponseTrait;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Http;
class PaymentController extends Controller
{
    use ResponseTrait;

    public function verify(Request $request)
    {
        $order_id = $request->get('id', '');
        $payerId = $request->get('PayerID', NULL);
        $payment_id = $request->get('payment_id', NULL);

        $order = Order::findOrFail($order_id);
        if ($order->payment_status == PAYMENT_STATUS_PAID) {
            return redirect()->route('thankyou');
        }

        $gateway = Gateway::find($order->gateway_id);
        $settingsService = new SettingsService();
        DB::beginTransaction();
        try {
            if ($order->gateway_id == $gateway->id && $gateway->slug == MERCADOPAGO) {
                $order->payment_id = $payment_id;
                $order->save();
            }

            $subscription = Subscription::find($order->subscription_id);
            $invoice = Invoice::where('subscription_id', $subscription->id)->first();
            
            $gatewayBasePayment = new Payment($gateway->slug, ['currency' => $order->gateway_currency, 'user_id' => $subscription->user_id]);
            $payment_data = $gatewayBasePayment->paymentConfirmation($order->payment_id, $payerId);
            if ($payment_data['success'] && $payment_data['data']['payment_status'] == 'success') {
                // Update subscription
                $end_date = $subscription->duration == DURATION_MONTH ? now()->addDays(30)->format('Y-m-d') : now()->addDays(365)->format('Y-m-d');
                $licenseData = License::where('product_plan', $subscription->plan_id)->first();
                if (!is_null($licenseData)) {
                    $subscription->license = $licenseData->code . str_replace('-', '', uuid_create(UUID_TYPE_RANDOM));
                }
                $subscription->status = STATUS_ACTIVE;
                $subscription->end_date = $end_date;
                $subscription->save();

                // Update invoice
                $invoice->payment_status = PAYMENT_STATUS_PAID;
                $invoice->save();

                // Update order
                $order->payment_status = PAYMENT_STATUS_PAID;
                $order->delivery_status = DELIVERY_STATUS_DELIVERED;
                $order->transaction_id = uniqid();
                $order->save();
                $gate = DB::table("gateway_currencies")->where(["gateway_id"=>17])->first();
                $rate = $gate->conversion_rate;
                // Insert into dev_main.transactions
                $sale_id = rand(100000, 999999);
               // Paystack fee calculation
$gross_amount = $invoice->amount * $rate;
$paystack_fee = ($gross_amount * 0.015) + 100;

if ($paystack_fee > 2000) {
    $paystack_fee = 2000;
}

$user = DB::table("user_details")->where(["user_id"=>$order->customer_id])->first();

\Log::info($order);
$net_amount = $gross_amount - $paystack_fee;


$email = $user->basic_email;
$webhookUrl = "https://api2.skool.com/groups/konnected-academy/webhooks/d0ce93d478d74d3b993f08d64ff48ec8?email=$email";

$response = Http::post($webhookUrl, [
    'email' => $email
]);

 
// Insert transaction
DB::connection('dev_main')->table('transactions')->insert([
    'wallet_id' => 237,
    'type' => 'pay-in',
    'amount' => $net_amount,
    'fee' => $paystack_fee,
    'reference' => $order->payment_id,
    'status' => 'successful',
    'phone' => $request->input('phone', ''),
    'description' => "Event registration - {$subscription->plan_id} plan for user {$subscription->user_id}",
    'sender_email' => "derrick@aktivepharmacy.com",
    'created_at' => now(),
    'updated_at' => now(),
    'userid' => 306,
    'sale_id' => $sale_id,
]);

// Insert payment sale
DB::connection('dev_main')->table('payment_sales')->insert([
    'user_id' => 306,
    'date' => now()->format('Y-m-d H:i:s'),
    'Ref' => $order->payment_id,
    'sale_id' => $sale_id,
    'montant' => $net_amount,
    'change' => 0,
    'payment_method_id' => 2,
    'notes' => "Event registration - {$subscription->plan_id} plan for user {$subscription->user_id}",
    'created_at' => now(),
    'updated_at' => now(),
    'userid' => 306,
]);

// Increment wallet balance
DB::connection('dev_main')
    ->table('wallets')
    ->where('id', 237)
    ->increment('balance', $net_amount);


                DB::commit();

                // Webhook and notification
                $webhookRequestData = [
                    'order_info' => $order,
                    'payment_info' => $payment_data,
                ];
                createWebhookEvent(WEBHOOK_EVENT_TYPE_PAYMENT, $subscription->plan_id, $subscription->user_id, $webhookRequestData);
                setCommonNotification('Have a new checkout', 'Order Id: ' . $order->order_id, '', $userId = $subscription->user_id);

                if (getOption('affiliate_status') == STATUS_ACTIVE) {
                    affiliateCommission($invoice);
                }

                // Send success email
                $settingsService->sendPaymentMail($subscription, $invoice, $order, EMAIL_TEMPLATE_PAYMENT_SUCCESS);
                return redirect()->route('thankyou');
            } else {
                $settingsService->sendPaymentMail($subscription, $invoice, $order, EMAIL_TEMPLATE_PAYMENT_FAILURE);
                return redirect()->route('failed');
            }
        } catch (Exception $e) {
            \Log::info($e);
            DB::rollBack();
            return redirect()->route('failed');
        }
    }

    public function thankyou()
    {
        return view('frontend.thankyou');
    }

    public function waiting()
    {
        return view('frontend.waiting');
    }

    public function failed()
    {
        return view('frontend.failed');
    }
}