<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to the "home" route for your application.
     *
     * Typically, users are redirected here after authentication.
     *
     * @var string
     */
    public const HOME = '/';

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     *
     * @return void
     */
    public function boot()
    {
        $this->configureRateLimiting();

        $this->routes(function () {
            Route::middleware('api')
                ->prefix('api')
                ->group(base_path('routes/api.php'));

            Route::middleware(['installed', 'web', 'version.update'])
                ->group(base_path('routes/web.php'));

            Route::middleware(['installed', 'web', 'auth', 'addon.update', 'admin', 'is_email_verify', '2fa_verify', 'version.update'])
                ->prefix('admin')
                ->as('admin.')
                ->group(base_path('routes/admin.php'));

            Route::middleware(['installed', 'web', 'auth', 'user', 'is_email_verify', 'version.update', '2fa_verify', 'common'])
                ->prefix('user')
                ->as('user.')
                ->group(base_path('routes/user.php'));

            Route::middleware(['installed', 'web', 'auth', 'affiliate', 'version.update', '2fa_verify', 'common'])
                ->prefix('affiliate')
                ->as('affiliate.')
                ->group(base_path('routes/affiliate.php'));

            if (isAddonInstalled('SUBSAAS') > 0) {
                Route::middleware(['installed', 'web', 'version.update'])
                    ->group(base_path('routes/saas.php'));
            }
        });
    }

    /**
     * Configure the rate limiters for the application.
     *
     * @return void
     */
    protected function configureRateLimiting()
    {
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });
    }
}
